
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the samba schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class SambaAttributeTypeProducer extends AbstractBootstrapProducer
{

    public SambaAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.24 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.24", registries );
        attributeType.setDescription( "LanManager Password" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaLMPassword" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.24", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.25 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.25", registries );
        attributeType.setDescription( "MD4 hash of the unicode password" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaNTPassword" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.25", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.26 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.26", registries );
        attributeType.setDescription( "Account Flags" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 16 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaAcctFlags" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.26", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.27 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.27", registries );
        attributeType.setDescription( "Timestamp of the last password update" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaPwdLastSet" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.27", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.28 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.28", registries );
        attributeType.setDescription( "Timestamp of when the user is allowed to update the password" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaPwdCanChange" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.28", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.29 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.29", registries );
        attributeType.setDescription( "Timestamp of when the password will expire" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaPwdMustChange" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.29", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.30 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.30", registries );
        attributeType.setDescription( "Timestamp of last logon" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaLogonTime" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.30", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.31 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.31", registries );
        attributeType.setDescription( "Timestamp of last logoff" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaLogoffTime" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.31", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.32 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.32", registries );
        attributeType.setDescription( "Timestamp of when the user will be logged off automatically" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaKickoffTime" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.32", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.48 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.48", registries );
        attributeType.setDescription( "Bad password attempt count" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaBadPasswordCount" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.48", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.49 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.49", registries );
        attributeType.setDescription( "Time of the last bad password attempt" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaBadPasswordTime" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.49", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.55 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.55", registries );
        attributeType.setDescription( "Logon Hours" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 42 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaLogonHours" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.55", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.33 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.33", registries );
        attributeType.setDescription( "Driver letter of home directory mapping" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 4 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaHomeDrive" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.33", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.34 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.34", registries );
        attributeType.setDescription( "Logon script path" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 255 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaLogonScript" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.34", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.35 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.35", registries );
        attributeType.setDescription( "Roaming profile path" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 255 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaProfilePath" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.35", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.36 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.36", registries );
        attributeType.setDescription( "List of user workstations the user is allowed to logon to" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 255 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaUserWorkstations" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.36", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.37 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.37", registries );
        attributeType.setDescription( "Home directory UNC path" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaHomePath" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.37", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.38 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.38", registries );
        attributeType.setDescription( "Windows NT domain to which the user belongs" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaDomainName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.38", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.47 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.47", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 1050 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaMungedDial" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.47", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.54 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.54", registries );
        attributeType.setDescription( "Concatenated MD4 hashes of the unicode passwords used on this account" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaPasswordHistory" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.54", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.20 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.20", registries );
        attributeType.setDescription( "Security ID" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 64 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaSID" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.20", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.23 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.23", registries );
        attributeType.setDescription( "Primary Group Security ID" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 64 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaPrimaryGroupSID" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.23", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.51 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.51", registries );
        attributeType.setDescription( "Security ID List" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 64 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaSIDList" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.51", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.19 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.19", registries );
        attributeType.setDescription( "NT Group Type" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaGroupType" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.19", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.21 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.21", registries );
        attributeType.setDescription( "Next NT rid to give our for users" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaNextUserRid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.21", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.22 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.22", registries );
        attributeType.setDescription( "Next NT rid to give out for groups" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaNextGroupRid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.22", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.39 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.39", registries );
        attributeType.setDescription( "Next NT rid to give out for anything" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaNextRid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.39", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.40 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.40", registries );
        attributeType.setDescription( "Base at which the samba RID generation algorithm should operate" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaAlgorithmicRidBase" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.40", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.41 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.41", registries );
        attributeType.setDescription( "Share Name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaShareName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.41", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.42 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.42", registries );
        attributeType.setDescription( "Option Name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaOptionName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.42", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.43 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.43", registries );
        attributeType.setDescription( "A boolean option" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "booleanMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.7" );

        names.clear();
        names.add( "sambaBoolOption" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.43", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.44 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.44", registries );
        attributeType.setDescription( "An integer option" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "sambaIntegerOption" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.44", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.45 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.45", registries );
        attributeType.setDescription( "A string option" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaStringOption" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.45", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.46 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.46", registries );
        attributeType.setDescription( "A string list option" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "sambaStringListOption" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.46", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.50 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.50", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "sambaPrivName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.50", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.52 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.52", registries );
        attributeType.setDescription( "Privileges List" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 64 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaPrivilegeList" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.52", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.7165.2.1.53 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.7165.2.1.53", registries );
        attributeType.setDescription( "Trust Password Flags" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "sambaTrustFlags" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.7165.2.1.53", attributeType );
    }
}
