/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLevelScopeEvaluator<E>
implements Evaluator<ScopeNode, E> {
    private final ScopeNode node;
    private final Long baseId;
    private final boolean dereferencing;
    private final Store<E> db;

    public OneLevelScopeEvaluator(Store<E> db, ScopeNode node) throws Exception {
        this.node = node;
        if (node.getScope() != SearchScope.ONELEVEL) {
            throw new IllegalStateException("ScopeNode is not of onelevel scope.");
        }
        this.db = db;
        this.baseId = db.getEntryId(node.getBaseDn());
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    public boolean evaluate(Long candidate) throws Exception {
        boolean isChild = this.db.getOneLevelIndex().forward((Object)this.baseId, candidate);
        if (!this.dereferencing) {
            return isChild;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate)) {
            return false;
        }
        if (isChild) {
            return true;
        }
        return this.db.getOneAliasIndex().forward((Object)this.baseId, candidate);
    }

    public boolean evaluate(E candidate) throws Exception {
        throw new UnsupportedOperationException("This is too inefficient without getId() on ServerEntry");
    }

    public boolean evaluate(IndexEntry<?, E> candidate) throws Exception {
        boolean isChild = this.db.getOneLevelIndex().forward((Object)this.baseId, candidate.getId());
        if (!this.dereferencing) {
            return isChild;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate.getId())) {
            return false;
        }
        if (isChild) {
            return true;
        }
        return this.db.getOneAliasIndex().forward((Object)this.baseId, candidate.getId());
    }

    public ScopeNode getExpression() {
        return this.node;
    }

    public Long getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }
}

