// $ANTLR 2.7.7 (20060906): "SubtreeSpecificationChecker.g" -> "AntlrSubtreeSpecificationChecker.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.shared.ldap.model.subtree;

import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.FilterParser;
import org.apache.directory.shared.util.ComponentsMonitor;
import org.apache.directory.shared.util.OptionalComponentsMonitor;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated subtree specification parser.
 *
 * @see <a href="http://www.faqs.org/rfcs/rfc3672.html">RFC 3672</a>
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrSubtreeSpecificationChecker extends antlr.LLkParser       implements AntlrSubtreeSpecificationCheckerTokenTypes
 {

    private static final Logger log = LoggerFactory.getLogger( AntlrSubtreeSpecificationChecker.class );
    
    private ComponentsMonitor subtreeSpecificationComponentsMonitor = null;
    
    /** The SchemaManager */
    private SchemaManager schemaManager;

    /**
     * Initiaize the checker
     */
    public void init( SchemaManager schemaManager )
    {
        this.schemaManager = schemaManager;
    }
    

    private int token2Integer( Token token ) throws RecognitionException
    {
        int i = 0;
        
        try
        {
            i = Integer.parseInt( token.getText());
        }
        catch ( NumberFormatException e )
        {
            throw new RecognitionException( "Value of INTEGER token " +
                                            token.getText() +
                                            " cannot be converted to an Integer" );
        }
        
        return i;
    }

protected AntlrSubtreeSpecificationChecker(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrSubtreeSpecificationChecker(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrSubtreeSpecificationChecker(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrSubtreeSpecificationChecker(TokenStream lexer) {
  this(lexer,1);
}

public AntlrSubtreeSpecificationChecker(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final void wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered wrapperEntryPoint()" );
		
		
		subtreeSpecification();
		match(LITERAL_end);
	}
	
	public final void subtreeSpecification() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered subtreeSpecification()" );
		subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor( 
		new String [] { "base", "specificExclusions", "minimum", "maximum", "specificationFilter" } );
		
		
		match(OPEN_CURLY);
		{
		_loop4:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop4;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		case ID_specificationFilter:
		{
			subtreeSpecificationComponent();
			{
			_loop7:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop7;
				}
				
			} while (true);
			}
			{
			_loop13:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop10:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop10;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop12:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop12;
						}
						
					} while (true);
					}
				}
				else {
					break _loop13;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered subtreeSpecification()" );
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_base:
			{
				ss_base();
				
				subtreeSpecificationComponentsMonitor.useComponent( "base" );
				
				break;
			}
			case ID_specificExclusions:
			{
				ss_specificExclusions();
				
				subtreeSpecificationComponentsMonitor.useComponent( "specificExclusions" );
				
				break;
			}
			case ID_minimum:
			{
				ss_minimum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "minimum" );
				
				break;
			}
			case ID_maximum:
			{
				ss_maximum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "maximum" );
				
				break;
			}
			case ID_specificationFilter:
			{
				ss_specificationFilter();
				
				subtreeSpecificationComponentsMonitor.useComponent( "specificationFilter" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_base()" );
		
		
		match(ID_base);
		{
		int _cnt17=0;
		_loop17:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt17>=1 ) { break _loop17; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt17++;
		} while (true);
		}
		distinguishedName();
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_specificExclusions()" );
		
		
		match(ID_specificExclusions);
		{
		int _cnt20=0;
		_loop20:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt20>=1 ) { break _loop20; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt20++;
		} while (true);
		}
		specificExclusions();
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_minimum()" );
		
		
		match(ID_minimum);
		{
		int _cnt46=0;
		_loop46:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt46>=1 ) { break _loop46; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt46++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_maximum()" );
		
		
		match(ID_maximum);
		{
		int _cnt49=0;
		_loop49:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt49>=1 ) { break _loop49; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt49++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void ss_specificationFilter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_specificationFilter()" );
		
		
		match(ID_specificationFilter);
		{
		int _cnt52=0;
		_loop52:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt52>=1 ) { break _loop52; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt52++;
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			{
			refinement();
			}
			break;
		}
		case FILTER:
		{
			{
			filter();
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void distinguishedName() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered distinguishedName()" );
		
		
		try {      // for error handling
			token = LT(1);
			match(SAFEUTF8STRING);
			
			new Dn( token.getText() );
			log.debug( "recognized a DistinguishedName: " + token.getText() );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( "dnParser failed for " + token.getText() + " " + e.getMessage() );
			
		}
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered specificExclusions()" );
		
		
		match(OPEN_CURLY);
		{
		_loop23:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop23;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop26:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop26;
				}
				
			} while (true);
			}
			{
			_loop32:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop29:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop29;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop31:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop31;
						}
						
					} while (true);
					}
				}
				else {
					break _loop32;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered specificExclusion()" );
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered chopBefore()" );
		
		
		match(ID_chopBefore);
		{
		_loop36:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop36;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop38:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop38;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered chopAfter()" );
		
		
		match(ID_chopAfter);
		{
		_loop41:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop41;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop43:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop43;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void baseDistance() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered baseDistance()" );
		
		
		token = LT(1);
		match(INTEGER);
		
		token2Integer(token);
		
	}
	
	public final void refinement() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered refinement()" );
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			item();
			break;
		}
		case ID_and:
		{
			and();
			break;
		}
		case ID_or:
		{
			or();
			break;
		}
		case ID_not:
		{
			not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void filter() throws RecognitionException, TokenStreamException {
		
		Token  filterToken = null;
		
		log.debug( "entered filter()" );
		
		
		try {      // for error handling
			{
			filterToken = LT(1);
			match(FILTER);
			FilterParser.parse( filterToken.getText() );
			}
		}
		catch (Exception e) {
			
			throw new RecognitionException( "filterParser failed. " + e.getMessage() );
			
		}
	}
	
	public final void oid() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered oid()" );
		Token token = null;
		
		
		token = LT( 1 );
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		log.debug( "recognized an oid: " + token.getText() );
		
	}
	
	public final void item() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered item()" );
		
		
		match(ID_item);
		{
		_loop65:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop65;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop67:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop67;
			}
			
		} while (true);
		}
		oid();
	}
	
	public final void and() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered and()" );
		
		
		match(ID_and);
		{
		_loop70:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop70;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop72:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop72;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void or() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered or()" );
		
		
		match(ID_or);
		{
		_loop75:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop75;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop77:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop77;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void not() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered not()" );
		
		
		match(ID_not);
		{
		_loop80:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop80;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop82:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop82;
			}
			
		} while (true);
		}
		refinement();
	}
	
	public final void refinements() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered refinements()" );
		
		
		match(OPEN_CURLY);
		{
		_loop85:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop85;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			refinement();
			{
			_loop88:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop88;
				}
				
			} while (true);
			}
			{
			_loop94:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop91:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop91;
						}
						
					} while (true);
					}
					refinement();
					{
					_loop93:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop93;
						}
						
					} while (true);
					}
				}
				else {
					break _loop94;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"end\"",
		"OPEN_CURLY",
		"SP",
		"SEP",
		"CLOSE_CURLY",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"COLON",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"\"specificationFilter\"",
		"FILTER",
		"SAFEUTF8STRING",
		"INTEGER",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"INTEGER_OR_NUMERICOID",
		"DOT",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"SAFEUTF8CHAR",
		"FILTER_VALUE"
	};
	
	
	}
