/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntry<K>
implements Entry {
    protected LdapDN dn;
    protected Map<K, EntryAttribute> attributes = new HashMap<K, EntryAttribute>();

    @Override
    public LdapDN getDn() {
        return this.dn;
    }

    @Override
    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Iterator<EntryAttribute> iterator() {
        return Collections.unmodifiableMap(this.attributes).values().iterator();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public Entry clone() {
        try {
            return (Entry)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

