/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.certGeneration;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationObject;
import org.apache.directory.shared.ldap.codec.extended.operations.certGeneration.CertGenerationStatesEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationGrammar
extends AbstractGrammar {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static IGrammar instance = new CertGenerationGrammar();

    public CertGenerationGrammar() {
        this.name = CertGenerationGrammar.class.getName();
        this.statesEnum = CertGenerationStatesEnum.getInstance();
        this.transitions = new GrammarTransition[6][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, (IAction)new GrammarAction("Init CertGenerationObject"){

            public void action(IAsn1Container container) {
                CertGenerationContainer certGenContainer = (CertGenerationContainer)container;
                CertGenerationObject certGenerationObject = new CertGenerationObject();
                certGenContainer.setCertGenerationObject(certGenerationObject);
            }
        });
        this.transitions[1][4] = new GrammarTransition(1, 2, 4, (IAction)new GrammarAction("Set Cert Generation target DN value"){

            public void action(IAsn1Container container) throws DecoderException {
                CertGenerationContainer CertGenContainer = (CertGenerationContainer)container;
                Value value = CertGenContainer.getCurrentTLV().getValue();
                String targetDN = StringTools.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Target DN = " + targetDN);
                }
                if (targetDN != null && targetDN.trim().length() > 0) {
                    if (!DN.isValid(targetDN)) {
                        String msg = I18n.err((String)"ERR_04032", (Object[])new Object[]{targetDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((String)"ERR_04033", (Object[])new Object[]{StringTools.dumpBytes(value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                CertGenContainer.getCertGenerationObject().setTargetDN(targetDN);
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, (IAction)new GrammarAction("Set Cert Generation issuer DN value"){

            public void action(IAsn1Container container) throws DecoderException {
                CertGenerationContainer CertGenContainer = (CertGenerationContainer)container;
                Value value = CertGenContainer.getCurrentTLV().getValue();
                String issuerDN = StringTools.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Issuer DN = " + issuerDN);
                }
                if (issuerDN != null && issuerDN.trim().length() > 0) {
                    if (!DN.isValid(issuerDN)) {
                        String msg = I18n.err((String)"ERR_04034", (Object[])new Object[]{issuerDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    CertGenContainer.getCertGenerationObject().setIssuerDN(issuerDN);
                }
            }
        });
        this.transitions[3][4] = new GrammarTransition(3, 4, 4, (IAction)new GrammarAction("Set Cert Generation subject DN value"){

            public void action(IAsn1Container container) throws DecoderException {
                CertGenerationContainer CertGenContainer = (CertGenerationContainer)container;
                Value value = CertGenContainer.getCurrentTLV().getValue();
                String subjectDN = StringTools.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("subject DN = " + subjectDN);
                }
                if (subjectDN != null && subjectDN.trim().length() > 0) {
                    if (!DN.isValid(subjectDN)) {
                        String msg = I18n.err((String)"ERR_04035", (Object[])new Object[]{subjectDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((String)"ERR_04033", (Object[])new Object[]{StringTools.dumpBytes(value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                CertGenContainer.getCertGenerationObject().setSubjectDN(subjectDN);
            }
        });
        this.transitions[4][4] = new GrammarTransition(4, 5, 4, (IAction)new GrammarAction("Set Cert Generation key algorithm value"){

            public void action(IAsn1Container container) throws DecoderException {
                CertGenerationContainer CertGenContainer = (CertGenerationContainer)container;
                Value value = CertGenContainer.getCurrentTLV().getValue();
                String keyAlgorithm = StringTools.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("key algorithm = " + keyAlgorithm);
                }
                if (keyAlgorithm != null && keyAlgorithm.trim().length() > 0) {
                    CertGenContainer.getCertGenerationObject().setKeyAlgorithm(keyAlgorithm);
                }
                CertGenContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

