/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public BooleanNormalizer() {
        super("2.5.13.13");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        return new StringValue(strValue.trim().toUpperCase());
    }

    @Override
    public String normalize(String value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        return value.trim().toUpperCase();
    }
}

