/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.asn1.ber.AbstractContainer;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.ldap.codec.LdapControlGrammar;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageGrammar;
import org.apache.directory.shared.ldap.codec.LdapResultGrammar;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestGrammar;
import org.apache.directory.shared.ldap.codec.add.AddRequestGrammar;
import org.apache.directory.shared.ldap.codec.add.AddResponseGrammar;
import org.apache.directory.shared.ldap.codec.bind.BindRequestGrammar;
import org.apache.directory.shared.ldap.codec.bind.BindResponseGrammar;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestGrammar;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseGrammar;
import org.apache.directory.shared.ldap.codec.del.DelRequestGrammar;
import org.apache.directory.shared.ldap.codec.del.DelResponseGrammar;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestGrammar;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseGrammar;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestGrammar;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseGrammar;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestGrammar;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseGrammar;
import org.apache.directory.shared.ldap.codec.search.FilterGrammar;
import org.apache.directory.shared.ldap.codec.search.MatchingRuleAssertionGrammar;
import org.apache.directory.shared.ldap.codec.search.SearchRequestGrammar;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneGrammar;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryGrammar;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceGrammar;
import org.apache.directory.shared.ldap.codec.search.SubstringFilterGrammar;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestGrammar;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapMessageContainer
extends AbstractContainer
implements IAsn1Container {
    private LdapMessage ldapMessage;
    private Set binaries;

    public LdapMessageContainer() {
        this(new HashSet());
    }

    public LdapMessageContainer(Set binaries) {
        this.currentGrammar = 0;
        this.grammars = new IGrammar[26];
        this.grammarStack = new IGrammar[10];
        this.stateStack = new int[10];
        this.popAllowedStack = new boolean[10];
        this.nbGrammars = 0;
        this.grammars[0] = LdapMessageGrammar.getInstance();
        this.grammars[2] = LdapControlGrammar.getInstance();
        this.grammars[3] = BindRequestGrammar.getInstance();
        this.grammars[1] = LdapResultGrammar.getInstance();
        this.grammars[4] = BindResponseGrammar.getInstance();
        this.grammars[5] = UnBindRequestGrammar.getInstance();
        this.grammars[6] = AbandonRequestGrammar.getInstance();
        this.grammars[7] = AddResponseGrammar.getInstance();
        this.grammars[8] = CompareResponseGrammar.getInstance();
        this.grammars[9] = DelResponseGrammar.getInstance();
        this.grammars[10] = ModifyResponseGrammar.getInstance();
        this.grammars[11] = ModifyDNResponseGrammar.getInstance();
        this.grammars[12] = SearchResultDoneGrammar.getInstance();
        this.grammars[13] = SearchRequestGrammar.getInstance();
        this.grammars[14] = FilterGrammar.getInstance();
        this.grammars[15] = SearchResultEntryGrammar.getInstance();
        this.grammars[16] = ModifyRequestGrammar.getInstance();
        this.grammars[17] = SearchResultReferenceGrammar.getInstance();
        this.grammars[18] = AddRequestGrammar.getInstance();
        this.grammars[19] = ModifyDNRequestGrammar.getInstance();
        this.grammars[20] = DelRequestGrammar.getInstance();
        this.grammars[21] = CompareRequestGrammar.getInstance();
        this.grammars[22] = ExtendedRequestGrammar.getInstance();
        this.grammars[23] = ExtendedResponseGrammar.getInstance();
        this.grammars[24] = SubstringFilterGrammar.getInstance();
        this.grammars[25] = MatchingRuleAssertionGrammar.getInstance();
        this.grammarStack[this.currentGrammar] = this.grammars[0];
        this.states = LdapStatesEnum.getInstance();
        this.binaries = binaries;
    }

    public LdapMessage getLdapMessage() {
        return this.ldapMessage;
    }

    public void setLdapMessage(LdapMessage ldapMessage) {
        this.ldapMessage = ldapMessage;
    }

    public void clean() {
        super.clean();
        this.ldapMessage = null;
    }

    public boolean isBinary(String id) {
        return this.binaries.contains(StringTools.lowerCase(StringTools.trim(id)));
    }
}

