/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)BindResponseGrammar.class);
    private static IGrammar instance = new BindResponseGrammar();

    private BindResponseGrammar() {
        this.name = BindResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_BIND_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.BIND_RESPONSE_TAG][97] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_TAG, LdapStatesEnum.BIND_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_VALUE][97] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_VALUE, LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, new GrammarAction("Init BindReponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindResponse bindResponse = new BindResponse();
                bindResponse.setParent(ldapMessage);
                ldapMessage.setProtocolOP(bindResponse);
            }
        });
        this.transitions[LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, 512, new GrammarAction("Allow pop"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_TAG][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_TAG, LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, -1, new GrammarAction("Store server sasl credentials value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindResponse bindResponseMessage = ldapMessageContainer.getLdapMessage().getBindResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    bindResponseMessage.setServerSaslCreds(new byte[0]);
                } else {
                    bindResponseMessage.setServerSaslCreds(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    log.debug("The SASL credentials value is : {}", (Object)bindResponseMessage.getServerSaslCreds().toString());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

