/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCredentials
extends LdapAuthentication {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleAuthentication.class);
    private LdapString mechanism;
    private byte[] credentials;
    private transient int mechanismLength;
    private transient int credentialsLength;

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public String getMechanism() {
        return this.mechanism == null ? null : this.mechanism.getString();
    }

    public void setMechanism(LdapString mechanism) {
        this.mechanism = mechanism;
    }

    public int computeLength() {
        this.mechanismLength = 1 + Length.getNbBytes((int)this.mechanism.getNbBytes()) + this.mechanism.getNbBytes();
        this.credentialsLength = 0;
        if (this.credentials != null) {
            this.credentialsLength = 1 + Length.getNbBytes((int)this.credentials.length) + this.credentials.length;
        }
        int saslLength = 1 + Length.getNbBytes((int)(this.mechanismLength + this.credentialsLength)) + this.mechanismLength + this.credentialsLength;
        if (log.isDebugEnabled()) {
            log.debug("SASL Authentication length : {}", (Object)new Integer(saslLength));
        }
        return saslLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-93);
            buffer.put(Length.getBytes((int)(this.mechanismLength + this.credentialsLength)));
            Value.encode((ByteBuffer)buffer, (String)this.mechanism.toString());
            if (this.credentials != null) {
                Value.encode((ByteBuffer)buffer, (byte[])this.credentials);
            }
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Sasl credentials\n");
        sb.append("            Mechanism :'").append(this.mechanism.toString()).append("'\n");
        if (this.credentials != null) {
            sb.append("            Credentials :'").append(this.credentials.toString()).append("'\n");
        }
        return sb.toString();
    }
}

