/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.del;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.del.DelResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)DelResponseGrammar.class);
    private static IGrammar instance = new DelResponseGrammar();

    private DelResponseGrammar() {
        this.name = DelResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_DEL_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.DEL_RESPONSE_TAG][107] = new GrammarTransition(LdapStatesEnum.DEL_RESPONSE_TAG, LdapStatesEnum.DEL_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.DEL_RESPONSE_VALUE][107] = new GrammarTransition(LdapStatesEnum.DEL_RESPONSE_VALUE, LdapStatesEnum.DEL_RESPONSE_LDAP_RESULT, new GrammarAction("Init DelResponse"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new DelResponse());
                log.debug("Del response ");
            }
        });
        this.transitions[LdapStatesEnum.DEL_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.DEL_RESPONSE_LDAP_RESULT, 512, new GrammarAction("Pop allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

