/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponse;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ExtendedResponseGrammar.class);
    private static IGrammar instance = new ExtendedResponseGrammar();

    private ExtendedResponseGrammar() {
        this.name = ExtendedResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_EXTENDED_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_TAG][120] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_TAG, LdapStatesEnum.EXTENDED_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_VALUE][120] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_VALUE, LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, new GrammarAction("Init Extended Reponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedResponse());
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, 512, new GrammarAction("Pop allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT][138] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE][138] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE, LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG, new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedResponse extendedResponse = ldapMessage.getExtendedResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                extendedResponse.setResponseName(new OID(StringTools.utf8ToString(tlv.getValue().getData())));
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    log.debug("OID read : {}", (Object)extendedResponse.getResponseName());
                }
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG][139] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG, LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE][139] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE, -1, new GrammarAction("Store response"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedResponse extendedResponse = ldapMessage.getExtendedResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    extendedResponse.setResponse(new byte[0]);
                } else {
                    extendedResponse.setResponse(tlv.getValue().getData());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (log.isDebugEnabled()) {
                    log.debug("Extended value : {}", extendedResponse.getResponse());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

