/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.codec.util.HttpClientError;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.codec.util.URIException;
import org.apache.directory.shared.ldap.codec.util.UrlDecoderException;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapURL
extends LdapString {
    public static final transient LdapURL EMPTY_URL = new LdapURL();
    private static FilterParserImpl filterParser = new FilterParserImpl();
    private String scheme;
    private String host;
    private int port;
    private LdapDN dn;
    private ArrayList attributes;
    private int scope;
    private String filter;
    private HashMap extensions;
    private HashMap criticalExtensions;

    public LdapURL() {
        this.host = null;
        this.port = -1;
        this.dn = null;
        this.attributes = new ArrayList();
        this.scope = 0;
        this.filter = null;
        this.extensions = new HashMap();
        this.criticalExtensions = new HashMap();
    }

    public void parse(char[] chars) throws LdapURLEncodingException {
        this.host = null;
        this.port = -1;
        this.dn = null;
        this.attributes = new ArrayList();
        this.scope = 0;
        this.filter = null;
        this.extensions = new HashMap();
        this.criticalExtensions = new HashMap();
        if (chars == null || chars.length == 0) {
            this.host = "";
            return;
        }
        int pos = 0;
        pos = StringTools.areEquals(chars, 0, "ldap://");
        if (pos == -1 && (pos = StringTools.areEquals(chars, 0, "ldaps://")) == -1) {
            throw new LdapURLEncodingException("A LdapUrl must start with \"ldap://\" or \"ldaps://\"");
        }
        this.scheme = new String(chars, 0, pos);
        if ((pos = this.parseHostPort(chars, pos)) == -1) {
            throw new LdapURLEncodingException("The hostport is invalid");
        }
        if (pos == chars.length) {
            return;
        }
        if (!StringTools.isCharASCII(chars, pos, '/')) {
            throw new LdapURLEncodingException("Bad character, position " + pos + ", '" + chars[pos] + "', '/' expected");
        }
        if (++pos == chars.length) {
            return;
        }
        if ((pos = this.parseDN(chars, pos)) == -1) {
            throw new LdapURLEncodingException("The DN is invalid");
        }
        if (pos == chars.length) {
            return;
        }
        if (!StringTools.isCharASCII(chars, pos, '?')) {
            throw new LdapURLEncodingException("Bad character, position " + pos + ", '" + chars[pos] + "', '?' expected");
        }
        ++pos;
        if ((pos = this.parseAttributes(chars, pos)) == -1) {
            throw new LdapURLEncodingException("Attributes are invalid");
        }
        if (pos == chars.length) {
            return;
        }
        if (!StringTools.isCharASCII(chars, pos, '?')) {
            throw new LdapURLEncodingException("Bad character, position " + pos + ", '" + chars[pos] + "', '?' expected");
        }
        ++pos;
        if ((pos = this.parseScope(chars, pos)) == -1) {
            throw new LdapURLEncodingException("Scope is invalid");
        }
        if (pos == chars.length) {
            return;
        }
        if (!StringTools.isCharASCII(chars, pos, '?')) {
            throw new LdapURLEncodingException("Bad character, position " + pos + ", '" + chars[pos] + "', '?' expected");
        }
        if (++pos == chars.length) {
            return;
        }
        if ((pos = this.parseFilter(chars, pos)) == -1) {
            throw new LdapURLEncodingException("Filter is invalid");
        }
        if (pos == chars.length) {
            return;
        }
        if (!StringTools.isCharASCII(chars, pos, '?')) {
            throw new LdapURLEncodingException("Bad character, position " + pos + ", '" + chars[pos] + "', '?' expected");
        }
        ++pos;
        if ((pos = this.parseExtensions(chars, pos)) == -1) {
            throw new LdapURLEncodingException("Extensions are invalid");
        }
        if (pos == chars.length) {
            return;
        }
        throw new LdapURLEncodingException("Invalid character at the end of the ldapUrl");
    }

    public LdapURL(String string) throws LdapURLEncodingException {
        if (string == null) {
            throw new LdapURLEncodingException("The string is empty : this is not a valid LdapURL.");
        }
        try {
            this.bytes = string.getBytes("UTF-8");
            this.string = string;
            this.parse(string.toCharArray());
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdapURLEncodingException("Bad Ldap URL : " + string);
        }
    }

    public LdapURL(byte[] bytes) throws LdapURLEncodingException {
        if (bytes == null || bytes.length == 0) {
            throw new LdapURLEncodingException("The byte array is empty : this is not a valid LdapURL.");
        }
        try {
            this.string = new String(bytes, "UTF-8");
            this.bytes = bytes;
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdapURLEncodingException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
        this.parse(this.string.toCharArray());
    }

    private int parseHost(char[] chars, int pos) {
        int start = pos;
        boolean hadDot = false;
        boolean hadMinus = false;
        boolean isHostNumber = true;
        boolean invalidIp = false;
        int nbDots = 0;
        int[] ipElem = new int[4];
        if (StringTools.isCharASCII(chars, pos, '-')) {
            return -1;
        }
        while (pos < chars.length && chars[pos] != ':' && chars[pos] != '/') {
            if (StringTools.isCharASCII(chars, pos, '.')) {
                if (hadMinus || hadDot) {
                    return -1;
                }
                if (isHostNumber && nbDots < 4 && ipElem[nbDots] > 65535) {
                    invalidIp = true;
                }
                hadDot = true;
                ++nbDots;
                ++pos;
                continue;
            }
            if (hadDot && StringTools.isCharASCII(chars, pos, '-')) {
                return -1;
            }
            hadDot = false;
            if (StringTools.isDigit(chars, pos)) {
                if (isHostNumber && nbDots < 4) {
                    ipElem[nbDots] = ipElem[nbDots] * 10 + (chars[pos] - 48);
                    if (ipElem[nbDots] > 65535) {
                        invalidIp = true;
                    }
                }
                hadMinus = false;
            } else if (StringTools.isAlphaDigitMinus(chars, pos)) {
                isHostNumber = false;
                hadMinus = StringTools.isCharASCII(chars, pos, '-');
            } else {
                return -1;
            }
            ++pos;
        }
        if (start == pos) {
            return pos;
        }
        if (isHostNumber) {
            if (nbDots != 3) {
                return -1;
            }
            if (invalidIp) {
                return -1;
            }
        }
        if (hadDot || hadMinus) {
            return -1;
        }
        this.host = new String(chars, start, pos - start);
        return pos;
    }

    private int parsePort(char[] chars, int pos) {
        if (!StringTools.isDigit(chars, pos)) {
            return -1;
        }
        this.port = chars[pos] - 48;
        ++pos;
        while (StringTools.isDigit(chars, pos)) {
            this.port = this.port * 10 + (chars[pos] - 48);
            if (this.port > 65535) {
                return -1;
            }
            ++pos;
        }
        return pos;
    }

    private int parseHostPort(char[] chars, int pos) {
        if ((pos = this.parseHost(chars, pos)) == -1) {
            return -1;
        }
        if (StringTools.isCharASCII(chars, pos, ':')) {
            ++pos;
        } else {
            return pos;
        }
        pos = this.parsePort(chars, pos);
        if (pos == -1) {
            return -1;
        }
        return pos;
    }

    public static String getString(byte[] data, int offset, int length, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, offset, length);
        }
    }

    public static String getString(byte[] data, String charset) {
        return LdapURL.getString(data, 0, data.length, charset);
    }

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    private static final byte[] decodeUrl(byte[] bytes) throws UrlDecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b == 37) {
                try {
                    int u = Character.digit((char)bytes[++i], 16);
                    int l = Character.digit((char)bytes[++i], 16);
                    if (u == -1 || l == -1) {
                        throw new UrlDecoderException("Invalid URL encoding");
                    }
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new UrlDecoderException("Invalid URL encoding");
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static String decode(String escaped) throws URIException {
        try {
            byte[] rawdata = LdapURL.decodeUrl(LdapURL.getAsciiBytes(escaped));
            return LdapURL.getString(rawdata, "UTF-8");
        }
        catch (UrlDecoderException e) {
            throw new URIException(e.getMessage());
        }
    }

    private int parseDN(char[] chars, int pos) {
        int end = pos;
        for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
            ++end;
        }
        try {
            this.dn = new LdapDN(LdapURL.decode(new String(chars, pos, end - pos)));
        }
        catch (URIException ue) {
            return -1;
        }
        catch (InvalidNameException de) {
            return -1;
        }
        return end;
    }

    private int parseAttributes(char[] chars, int pos) {
        int start = pos;
        int end = pos;
        HashSet<String> hAttributes = new HashSet<String>();
        boolean hadComma = false;
        try {
            for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
                if (StringTools.isCharASCII(chars, i, ',')) {
                    hadComma = true;
                    if (end - start == 0) {
                        return -1;
                    }
                    String attribute = null;
                    attribute = new String(chars, start, end - start).trim();
                    if (attribute.length() == 0) {
                        return -1;
                    }
                    String decodedAttr = LdapURL.decode(attribute);
                    if (!hAttributes.contains(decodedAttr)) {
                        this.attributes.add(decodedAttr);
                        hAttributes.add(decodedAttr);
                    }
                    start = i + 1;
                } else {
                    hadComma = false;
                }
                ++end;
            }
            if (hadComma) {
                return -1;
            }
            if (end == start) {
                return end;
            }
            String attribute = null;
            attribute = new String(chars, start, end - start).trim();
            if (attribute.length() == 0) {
                return -1;
            }
            String decodedAttr = LdapURL.decode(attribute);
            if (!hAttributes.contains(decodedAttr)) {
                this.attributes.add(decodedAttr);
                hAttributes.add(decodedAttr);
            }
            return end;
        }
        catch (URIException ue) {
            return -1;
        }
    }

    private int parseFilter(char[] chars, int pos) {
        int end = pos;
        for (int i = pos; i < chars.length && chars[i] != '?'; ++i) {
            ++end;
        }
        try {
            this.filter = LdapURL.decode(new String(chars, pos, end - pos));
            filterParser.parse(this.filter);
        }
        catch (URIException ue) {
            return -1;
        }
        catch (IOException ioe) {
            return -1;
        }
        catch (ParseException pe) {
            return -1;
        }
        return end;
    }

    private int parseScope(char[] chars, int pos) {
        if (StringTools.isCharASCII(chars, pos, 'b') || StringTools.isCharASCII(chars, pos, 'B')) {
            if ((StringTools.isCharASCII(chars, ++pos, 'a') || StringTools.isCharASCII(chars, pos, 'A')) && (StringTools.isCharASCII(chars, ++pos, 's') || StringTools.isCharASCII(chars, pos, 'S')) && (StringTools.isCharASCII(chars, ++pos, 'e') || StringTools.isCharASCII(chars, pos, 'E'))) {
                this.scope = 0;
                return ++pos;
            }
        } else if (StringTools.isCharASCII(chars, pos, 'o') || StringTools.isCharASCII(chars, pos, 'O')) {
            if ((StringTools.isCharASCII(chars, ++pos, 'n') || StringTools.isCharASCII(chars, pos, 'N')) && (StringTools.isCharASCII(chars, ++pos, 'e') || StringTools.isCharASCII(chars, pos, 'E'))) {
                this.scope = 1;
                return ++pos;
            }
        } else if (StringTools.isCharASCII(chars, pos, 's') || StringTools.isCharASCII(chars, pos, 'S')) {
            if ((StringTools.isCharASCII(chars, ++pos, 'u') || StringTools.isCharASCII(chars, pos, 'U')) && (StringTools.isCharASCII(chars, ++pos, 'b') || StringTools.isCharASCII(chars, pos, 'B'))) {
                this.scope = 2;
                return ++pos;
            }
        } else if (StringTools.isCharASCII(chars, pos, '?')) {
            return pos;
        }
        return -1;
    }

    private int parseExtensions(char[] chars, int pos) {
        int start = pos;
        boolean isCritical = false;
        boolean isNewExtension = true;
        boolean hasValue = false;
        String extension = null;
        String value = null;
        if (pos == chars.length) {
            return pos;
        }
        try {
            for (int i = pos; i < chars.length; ++i) {
                if (StringTools.isCharASCII(chars, i, ',')) {
                    if (isNewExtension) {
                        return -1;
                    }
                    value = new String(LdapURL.decode(new String(chars, start, i - start))).trim();
                    if (value.length() == 0) {
                        return -1;
                    }
                    if (isCritical) {
                        this.criticalExtensions.put(extension, value);
                    } else {
                        this.extensions.put(extension, value);
                    }
                    isNewExtension = true;
                    hasValue = false;
                    isCritical = false;
                    start = i + 1;
                    extension = null;
                    value = null;
                    continue;
                }
                if (StringTools.isCharASCII(chars, i, '=')) {
                    if (hasValue) continue;
                    extension = new String(LdapURL.decode(new String(chars, start, i - start))).trim();
                    if (extension.length() == 0) {
                        return -1;
                    }
                    isNewExtension = false;
                    hasValue = true;
                    start = i + 1;
                    continue;
                }
                if (!StringTools.isCharASCII(chars, i, '!')) continue;
                if (!isNewExtension) {
                    return -1;
                }
                isCritical = true;
                ++start;
            }
            if (extension == null) {
                extension = new String(LdapURL.decode(new String(chars, start, chars.length - start))).trim();
            } else {
                value = new String(LdapURL.decode(new String(chars, start, chars.length - start))).trim();
            }
            if (isCritical) {
                this.criticalExtensions.put(extension, value);
            } else {
                this.extensions.put(extension, value);
            }
            return chars.length;
        }
        catch (URIException ue) {
            return -1;
        }
    }

    private String urlEncode(String string, boolean doubleEncode) {
        StringBuffer sb = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    sb.append("%20");
                    continue block6;
                }
                case '?': {
                    sb.append("%3f");
                    continue block6;
                }
                case '\\': {
                    sb.append("%5c");
                    continue block6;
                }
                case ',': {
                    if (doubleEncode) {
                        sb.append("%2c");
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ldap://");
        sb.append(this.host == null ? "" : this.host);
        if (this.port != -1) {
            sb.append(':').append(this.port);
        }
        if (this.dn != null) {
            sb.append('/').append(this.urlEncode(this.dn.toString(), false));
            if (this.attributes.size() != 0 || this.scope != 0 || this.filter != null || this.extensions.size() != 0 || this.criticalExtensions.size() != 0) {
                sb.append('?');
                for (int i = 0; i < this.attributes.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.urlEncode((String)this.attributes.get(i), false));
                }
            }
            if (this.scope != 0 || this.filter != null || this.extensions.size() != 0 || this.criticalExtensions.size() != 0) {
                sb.append('?');
                switch (this.scope) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        sb.append("one");
                        break;
                    }
                    case 2: {
                        sb.append("sub");
                    }
                }
                if (this.filter != null || this.extensions.size() != 0 || this.criticalExtensions.size() != 0) {
                    sb.append("?");
                    if (this.filter != null) {
                        sb.append(this.urlEncode(this.filter, false));
                    }
                    if (this.extensions.size() != 0 || this.criticalExtensions.size() != 0) {
                        String key;
                        Iterator keys;
                        sb.append('?');
                        boolean isFirst = true;
                        if (this.extensions.size() != 0) {
                            keys = this.extensions.keySet().iterator();
                            while (keys.hasNext()) {
                                if (!isFirst) {
                                    sb.append(',');
                                } else {
                                    isFirst = false;
                                }
                                key = (String)keys.next();
                                sb.append(this.urlEncode(key, false)).append('=').append(this.urlEncode((String)this.extensions.get(key), true));
                            }
                        }
                        isFirst = true;
                        if (this.criticalExtensions.size() != 0) {
                            keys = this.criticalExtensions.keySet().iterator();
                            while (keys.hasNext()) {
                                if (!isFirst) {
                                    sb.append(",!");
                                } else {
                                    sb.append('!');
                                    isFirst = false;
                                }
                                key = (String)keys.next();
                                sb.append(this.urlEncode(key, false)).append('=').append(this.urlEncode((String)this.criticalExtensions.get(key), true));
                            }
                        }
                    }
                }
            }
        } else {
            sb.append('/');
        }
        return sb.toString();
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public HashMap getCriticalExtensions() {
        return this.criticalExtensions;
    }

    public LdapDN getDn() {
        return this.dn;
    }

    public HashMap getExtensions() {
        return this.extensions;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getScope() {
        return this.scope;
    }

    public String getScheme() {
        return this.scheme;
    }
}

