/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Serializable;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeAndValue
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((Class)AttributeTypeAndValue.class);
    private String type;
    private String value;
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean CASE_INSENSITIVE = false;

    public AttributeTypeAndValue() {
        this.type = null;
        this.value = null;
    }

    public AttributeTypeAndValue(String type, String value) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("Null or empty type is not allowed");
        }
        this.type = type;
        this.value = StringTools.isEmpty(value) ? "" : value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type)) {
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null : ");
        }
        this.type = type;
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        this.type = StringTools.lowerCase(StringTools.trim(type));
        if (StringTools.isEmpty(this.type)) {
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null : ");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringTools.isEmpty(value) ? "" : value;
    }

    public void setValueNormalized(String value) {
        String newValue = StringTools.trim(value);
        this.value = StringTools.isEmpty(newValue) ? "" : newValue;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.type, nc.type);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, true);
        }
        return 1;
    }

    public int compareToIgnoreCase(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.type, nc.type);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, false);
        }
        return 1;
    }

    private int compareType(String val1, String val2) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        return StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
    }

    private int compareValue(String val1, String val2, boolean sensitivity) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        int res = 0;
        res = sensitivity ? StringTools.trim(val1).compareTo(StringTools.trim(val2)) : StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
        return res < 0 ? -1 : (res > 0 ? 1 : 0);
    }

    public String normalize() {
        return StringTools.lowerCase(StringTools.trim(this.type)) + '=' + StringTools.trim(this.value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (StringTools.isEmpty(this.type) || StringTools.isEmpty(this.type.trim())) {
            return "";
        }
        sb.append(this.type).append("=");
        if (this.value != null) {
            sb.append(this.value);
        }
        return sb.toString();
    }
}

