/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAttributeDescFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitAttributeDescFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitAttributeDescFilterAction() {
        super("Initialize AttributeDesc filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        AttributeValueAssertion assertion = new AttributeValueAssertion();
        if (tlv.getLength() == 0) {
            log.error("The attribute description is empty ");
            throw new DecoderException("The type can't be null");
        }
        String type = new String(tlv.getValue().getData());
        assertion.setAttributeDesc(type);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter();
        terminalFilter.setAssertion(assertion);
        if (IS_DEBUG) {
            log.debug("Initialize AttributeDesc filter");
        }
    }
}

