// $ANTLR 2.7.4: "filter-parser.g" -> "AntlrFilterParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.shared.ldap.filter;


import antlr.*;
import java.util.ArrayList;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.shared.ldap.filter.AssertionEnum;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * An LDAP filter parser.
 *
 * @see <a href="http://ietf.org/internet-drafts/draft-ietf-ldapbis-filter-08.txt">String Representation of Search Filters</a>
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrFilterParser extends antlr.LLkParser       implements AntlrFilterParserTokenTypes
 {

    /** the monitor used to track the activities of this parser */
    FilterParserMonitor monitor;
    /** the token stream selector used for multiplexing the underlying stream */
    TokenStreamSelector selector;
    /** the filter value encoding lexer */
    AntlrFilterValueLexer valueLexer;
    /** the value parser pulling tokens from the value lexer */
    AntlrFilterValueParser valueParser;


    /**
     * Sets the token stream selector used for multiplexing the underlying stream.
     *
     * @param selector the token stream selector used for multiplexing
     */
    public void setSelector( TokenStreamSelector selector )
    {
        this.selector = selector;
    }


    /**
     * Sets the filter value encoding lexer.
     *
     * @param valueLexer the filter value encoding lexer
     */
    public void setValueLexer( AntlrFilterValueLexer valueLexer )
    {
        this.valueLexer = valueLexer;
    }


    /**
     * Sets the value parser pulling tokens from the value lexer.
     *
     * @param valueParser value parser pulling tokens from the value lexer
     */
    public void setValueParser( AntlrFilterValueParser valueParser )
    {
        this.valueParser = valueParser;
    }


    /**
     * Sets the monitor used to track the activities of this parser.
     *
     * @param monitor used to track the activities of this parser
     */
    public void setFilterParserMonitor( FilterParserMonitor monitor )
    {
        this.monitor = monitor;
    }


    /**
     * Monitors FilterParser events where it matches a production.
     *
     * @param production the name of the production matched
     */
    private void matchedProduction( String production )
    {
        if ( this.monitor != null )
        {
            this.monitor.matchedProduction( production );
        }
    }

protected AntlrFilterParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrFilterParser(TokenBuffer tokenBuf) {
  this(tokenBuf,5);
}

protected AntlrFilterParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrFilterParser(TokenStream lexer) {
  this(lexer,5);
}

public AntlrFilterParser(ParserSharedInputState state) {
  super(state,5);
  tokenNames = _tokenNames;
}

/**
 * The top level production for matching a filter expression.
 */
	public final ExprNode  filter() throws RecognitionException, TokenStreamException {
		ExprNode node;
		
		
		node = null;
		
		
		match(LPAREN);
		node=filtercomp();
		return node;
	}
	
/**
 * A production for matching composite filter expressions.
 */
	public final ExprNode  filtercomp() throws RecognitionException, TokenStreamException {
		ExprNode node;
		
		
		node = null;
		
		
		switch ( LA(1)) {
		case AMPERSTAND:
		{
			node=and();
			match(RPAREN);
			break;
		}
		case VERTBAR:
		{
			node=or();
			match(RPAREN);
			break;
		}
		case EXCLAMATION:
		{
			node=not();
			match(RPAREN);
			break;
		}
		case COLON:
		case DN:
		case COLONEQUALS:
		case ATTRIBUTEDESCRIPTION:
		{
			node=item();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return node;
	}
	
/**
 * A recursive production for matching AND'd filter expressions.
 */
	public final BranchNode  and() throws RecognitionException, TokenStreamException {
		BranchNode node;
		
		
		node = null;
		ExprNode child;
		ArrayList children = new ArrayList();
		
		
		match(AMPERSTAND);
		child=filter();
		
		children.add( child );
		
		{
		_loop89:
		do {
			if ((LA(1)==LPAREN)) {
				child=filter();
				
				children.add( child );
				
			}
			else {
				break _loop89;
			}
			
		} while (true);
		}
		
		node = new BranchNode( AssertionEnum.AND, children );
		
		return node;
	}
	
/**
 * A recursive production for matching OR'd filter expressions.
 */
	public final BranchNode  or() throws RecognitionException, TokenStreamException {
		BranchNode node;
		
		
		node = null;
		ExprNode child;
		ArrayList children = new ArrayList();
		
		
		match(VERTBAR);
		child=filter();
		
		children.add( child );
		
		{
		_loop92:
		do {
			if ((LA(1)==LPAREN)) {
				child=filter();
				
				children.add( child );
				
			}
			else {
				break _loop92;
			}
			
		} while (true);
		}
		
		node = new BranchNode( AssertionEnum.OR, children );
		
		return node;
	}
	
/**
 * A recursive production for matching negated filter expressions.
 */
	public final BranchNode  not() throws RecognitionException, TokenStreamException {
		BranchNode node;
		
		
		node = null;
		ExprNode child;
		
		
		match(EXCLAMATION);
		child=filter();
		
		node = new BranchNode( AssertionEnum.NOT );
		node.addNode( child );
		
		return node;
	}
	
/**
 * A production for matching all non-terminal assertions.  This includes
 * extensible, presence, substring, greaterorequal, lessorequal, and equality
 * filter assertions.
 */
	public final LeafNode  item() throws RecognitionException, TokenStreamException {
		LeafNode node;
		
		
		node = null;
		
		
		if ((LA(1)==ATTRIBUTEDESCRIPTION) && (_tokenSet_0.member(LA(2)))) {
			node=simple();
		}
		else if ((LA(1)==COLON||LA(1)==DN||LA(1)==ATTRIBUTEDESCRIPTION) && (_tokenSet_1.member(LA(2)))) {
			node=extensible();
		}
		else if ((LA(1)==COLONEQUALS)) {
			{
			match(COLONEQUALS);
			
			selector.select( valueLexer );
			String value = ( ( String ) valueParser.value( null ) ).trim();
			node = new ExtensibleNode( null, value, null, false );
			
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		return node;
	}
	
/**
 * General filter assertion matching production for approximate, greater or
 * equal, less or equal, equals, substring, and presence simple items,
 */
	public final LeafNode  simple() throws RecognitionException, TokenStreamException {
		LeafNode node;
		
		Token  token = null;
		
		String attribute = null;
		node = null;
		AssertionEnum type = null;
		
		
		token = LT(1);
		match(ATTRIBUTEDESCRIPTION);
		
		attribute = token.getText();
		
		{
		switch ( LA(1)) {
		case APPROX:
		{
			match(APPROX);
			
			type = AssertionEnum.APPROXIMATE;
			
			break;
		}
		case GREATEROREQUAL:
		{
			match(GREATEROREQUAL);
			
			type = AssertionEnum.GREATEREQ;
			
			break;
		}
		case LESSOREQUAL:
		{
			match(LESSOREQUAL);
			
			type = AssertionEnum.LESSEQ;
			
			break;
		}
		case EQUALS:
		{
			match(EQUALS);
			
			type = AssertionEnum.EQUALITY;
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		selector.select( valueLexer );
		Object value = valueParser.value( attribute );
		
		if ( value instanceof String )
		{
		String str = ( String ) value;
		if ( str.charAt( 0 ) == '#' )
		{
		value = StringTools.toByteArray( str.substring( 1 ) );
		}
		else
		{
		value = str.trim();
		}
		}
		
		switch( type )
		{
		case APPROXIMATE :
		case GREATEREQ :
		case LESSEQ :
		if ( value instanceof String )
		{
		node = new SimpleNode( attribute, ( String ) value, type );
		}
		else if ( value instanceof byte[] )
		{
		node = new SimpleNode( attribute, ( byte[] ) value, type );
		}
		break;
		
		case EQUALITY :
		if ( value instanceof String )
		{
		node = new SimpleNode( attribute, ( String ) value, type );
		}
		else if ( value instanceof byte[] )
		{
		node = new SimpleNode( attribute, ( byte[] ) value, type );
		}
		else
		{
		node = ( LeafNode ) value;
		}
		break;
		
		default:
		throw new IllegalStateException( "Expecting one of 4 types" );
		}
		
		return node;
	}
	
/**
 * Extensible filter assertion matching production.
 */
	public final ExtensibleNode  extensible() throws RecognitionException, TokenStreamException {
		ExtensibleNode node;
		
		Token  attributeAlt1 = null;
		Token  matchingRuleAlt1 = null;
		Token  matchingRuleAlt2 = null;
		
		node = null;
		boolean dnAttrs = false;
		String attribute = null;
		String matchingRule = null;
		String value = null;
		
		
		{
		switch ( LA(1)) {
		case ATTRIBUTEDESCRIPTION:
		{
			attributeAlt1 = LT(1);
			match(ATTRIBUTEDESCRIPTION);
			
			attribute = attributeAlt1.getText().trim();
			
			{
			switch ( LA(1)) {
			case DN:
			{
				match(DN);
				dnAttrs = true;
				break;
			}
			case COLON:
			case COLONEQUALS:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case COLON:
			{
				match(COLON);
				matchingRuleAlt1 = LT(1);
				match(ATTRIBUTEDESCRIPTION);
				
				matchingRule = matchingRuleAlt1.getText().trim();
				int idx = matchingRule.indexOf( ';' );
				if ( idx != -1 )
				{
				String msg = "matchingRule OIDs cannot have options: ";
				msg += matchingRule;
				throw new RecognitionException( msg, matchingRule, 0, idx );
				}
				
				break;
			}
			case COLONEQUALS:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(COLONEQUALS);
			
			selector.select( valueLexer );
			value = ( ( String ) valueParser.value( attribute ) ).trim();
			
			break;
		}
		case COLON:
		case DN:
		{
			{
			switch ( LA(1)) {
			case DN:
			{
				match(DN);
				dnAttrs = true;
				break;
			}
			case COLON:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(COLON);
			matchingRuleAlt2 = LT(1);
			match(ATTRIBUTEDESCRIPTION);
			
			matchingRule = matchingRuleAlt2.getText().trim();
			int idx = matchingRule.indexOf( ';' );
			if ( idx != -1 )
			{
			String msg = "matchingRule OIDs cannot have options: ";
			msg += matchingRule;
			throw new RecognitionException( msg, matchingRule, 0, idx );
			}
			
			match(COLONEQUALS);
			
			selector.select( valueLexer );
			value = ( ( String ) valueParser.value( attribute ) ).trim();
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		node = new ExtensibleNode( attribute, value, matchingRule, dnAttrs );
		
		return node;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"DIGIT",
		"HEXDIG",
		"VALUEENCODING",
		"NORMAL",
		"ESCAPED",
		"UTF1SUBSET",
		"EXCLAMATION",
		"AMPERSAND",
		"ASTERISK",
		"LPAREN",
		"RPAREN",
		"COLON",
		"VERTBAR",
		"TILDE",
		"ESC",
		"UTF8",
		"UTFMB",
		"UTF0",
		"UTF1",
		"UTF2",
		"UTF3",
		"UTF4",
		"WS",
		"RANGLE",
		"LANGLE",
		"EQUALS",
		"AMPERSTAND",
		"DN",
		"COLONEQUALS",
		"APPROX",
		"GREATEROREQUAL",
		"LESSOREQUAL",
		"LDIGIT",
		"ALPHA",
		"NUMBER",
		"NUMERICOID",
		"DESCR",
		"OID",
		"OPTION",
		"OPTIONS",
		"ATTRIBUTEDESCRIPTION"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 60666413056L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 17598628528128L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	
	}
