// $ANTLR 2.7.4: "filter-value-parser.g" -> "AntlrFilterValueParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.shared.ldap.filter;


import antlr.*;
import java.util.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * A filter assertion value encoding parser.  This parser is used by the top
 * filter parser to handle equality, extensible, presence and substring
 * assertion values.  It also participates in multiplexing the underlying
 * token stream by driving filter assertion value lexer.
 *
 * @see <a href="http://ietf.org/internet-drafts/draft-ietf-ldapbis-filter-08.txt">String Representation of Search Filters</a>
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class AntlrFilterValueParser extends antlr.LLkParser       implements AntlrFilterValueParserTokenTypes
 {

    /** the monitor used to track the activities of this parser */
    FilterParserMonitor monitor;
    /** the primary lexer used by the filter parser */
    AntlrFilterLexer lexer;
    /** the token stream selector for the filter parser */
    TokenStreamSelector selector;


    /**
     * Sets the token stream select so we can use it to switch to the filter
     * parsers primary lexer.
     *
     * @param selector the token stream selector for the filter parser
     */
    public void setSelector( TokenStreamSelector selector )
    {
        this.selector = selector;
    }


    /**
     * Sets the filter's main lexer so we can switch back to it.
     *
     * @param lexer the primary lexer used by the filter parser
     */
    public void setLexer( AntlrFilterLexer lexer )
    {
        this.lexer = lexer;
    }


    /**
     * Sets the monitor used to track the activities of this parser.
     *
     * @param monitor used to track the activities of this parser
     */
    public void setFilterParserMonitor( FilterParserMonitor monitor )
    {
        this.monitor = monitor;
    }


    /**
     * Monitors FilterParser events where it matches a production.
     *
     * @param production the name of the production matched
     */
    private void matchedProduction( String production )
    {
        if ( this.monitor != null )
        {
            this.monitor.matchedProduction( production );
        }
    }

protected AntlrFilterValueParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrFilterValueParser(TokenBuffer tokenBuf) {
  this(tokenBuf,3);
}

protected AntlrFilterValueParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrFilterValueParser(TokenStream lexer) {
  this(lexer,3);
}

public AntlrFilterValueParser(ParserSharedInputState state) {
  super(state,3);
  tokenNames = _tokenNames;
}

/**
 * Parser production that calls either equal, presence or substring productions.
 */
	public final Object  value(
		String attribute
	) throws RecognitionException, TokenStreamException {
		Object node;
		
		
		node = null;
		
		
		{
		if ((LA(1)==VALUEENCODING) && (LA(2)==RPAREN)) {
			node=equal();
		}
		else if ((LA(1)==ASTERISK) && (LA(2)==RPAREN)) {
			node=presence(attribute);
		}
		else if ((LA(1)==VALUEENCODING||LA(1)==ASTERISK) && (LA(2)==VALUEENCODING||LA(2)==ASTERISK)) {
			node=substring(attribute);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		return node;
	}
	
/**
 * Parser production that parses the equality expression value immediately
 * after the '=' in a filter equality assertion.
 */
	public final String  equal() throws RecognitionException, TokenStreamException {
		String retval;
		
		Token  val = null;
		
		retval = null;
		
		
		val = LT(1);
		match(VALUEENCODING);
		
		selector.select( lexer );
		retval = val.getText();
		
		match(RPAREN);
		return retval;
	}
	
/**
 * Parser production that parses the presence expressions immediately after the
 * '=' in a presence assertion.
 */
	public final PresenceNode  presence(
		String attribute
	) throws RecognitionException, TokenStreamException {
		PresenceNode node;
		
		
		node = null;
		
		
		match(ASTERISK);
		
		selector.select( lexer );
		node = new PresenceNode( attribute.trim() );
		
		match(RPAREN);
		return node;
	}
	
/**
 * Parser production that parses the substring expression value immediately
 * after the '=' in a substring filter assertion.
 */
	public final LeafNode  substring(
		String attribute
	) throws RecognitionException, TokenStreamException {
		LeafNode node;
		
		Token  alt1 = null;
		Token  alt2 = null;
		Token  alt3t0 = null;
		Token  alt3t1 = null;
		
		node = null;
		String initial = null;
		String fin = null;
		ArrayList any = new ArrayList();
		
		
		{
		if ((LA(1)==VALUEENCODING) && (LA(2)==ASTERISK) && (LA(3)==RPAREN)) {
			alt1 = LT(1);
			match(VALUEENCODING);
			
			initial = alt1.getText().trim();
			
			match(ASTERISK);
		}
		else if ((LA(1)==ASTERISK)) {
			{
			int _cnt81=0;
			_loop81:
			do {
				if ((LA(1)==ASTERISK) && (LA(2)==VALUEENCODING)) {
					match(ASTERISK);
					alt2 = LT(1);
					match(VALUEENCODING);
					
					if ( fin != null && fin.length() > 0 )
					{
					any.add( fin );
					}
					
					fin = alt2.getText().trim();
					
				}
				else {
					if ( _cnt81>=1 ) { break _loop81; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt81++;
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ASTERISK:
			{
				match(ASTERISK);
				
				if ( fin != null && fin.length() > 0 )
				{
				any.add( fin );
				}
				
				fin = null;
				
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((LA(1)==VALUEENCODING) && (LA(2)==ASTERISK) && (LA(3)==VALUEENCODING)) {
			alt3t0 = LT(1);
			match(VALUEENCODING);
			
			initial = alt3t0.getText().trim();
			
			{
			int _cnt84=0;
			_loop84:
			do {
				if ((LA(1)==ASTERISK)) {
					match(ASTERISK);
					alt3t1 = LT(1);
					match(VALUEENCODING);
					
					if ( fin != null && fin.length() > 0 )
					{
					any.add( fin );
					}
					
					fin = alt3t1.getText().trim();
					
				}
				else {
					if ( _cnt84>=1 ) { break _loop84; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt84++;
			} while (true);
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		match(RPAREN);
		
		selector.select( lexer );
		
		/*
		* Under special circumstances a presence string can appear to be a
		* SubstringNode.  Namely the following too filters are not equal:
		*
		* (ou=*) != (ou=* )
		*
		* The first on the left hand side has no space between the '*' and the
		* closing parenthesis.  The 2nd on the right hand side has a space.  So
		* the question arrises how do we interpret this.  Intuitively both
		* would be considered the same and that's what we shall do until we ask
		* on the LDAPBIS mailing list.  However note that the first filter will
		* be processed by the presence rule while the second will be processed
		* by this rule the substring rule.  That is because according to the
		* parser white space is significant as it should be in the value
		* encoding just not on the periphery.  So as a substring the 2nd filter
		* would be interpretted as a search for all ou values ending in a
		* whitespace.  Again intuitively this does not make sense.  I would
		* imagine it best if this is what was intended that the escape sequence
		* '\20' be used for white space rather than using actual whitespace on
		* the periphery.
		*
		* So what do we do to solve this problem.  Well we need to characterize
		* first the range of errors that are possible.  First any one of these
		* filters are valid presence filters (note whitespace differences):
		*    #1       #2           #3         #4
		* (ou= * ) (ou=  *) (   ou  =  *  ) (ou=* )
		*
		* #1: initial = " ", any is empty, final = " "
		* #2: initial = "  ", any is empty, final = null
		* #3: initial = "  ", any is empty, final = "  "
		* #4: initial = null, any is empty, final = " "
		*
		* To handle this and generate the appropriate node type we check for
		* null, empty strings, and empty any arrays in the condition below:
		*/
		if ( any.isEmpty()
		&& ( initial == null || initial.trim().length() == 0 )
		&& ( fin == null || fin.trim().length() == 0 ) )
		{
		node = new PresenceNode( attribute );
		}
		else
		{
		if ( initial != null && initial.length() == 0 )
		{
		initial = null;
		}
		
		if ( fin != null && fin.length() == 0 )
		{
		fin = null;
		}
		
		node = new SubstringNode( any, attribute, initial, fin );
		}
		
		return node;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"DIGIT",
		"HEXDIG",
		"VALUEENCODING",
		"NORMAL",
		"ESCAPED",
		"UTF1SUBSET",
		"EXCLAMATION",
		"AMPERSAND",
		"ASTERISK",
		"LPAREN",
		"RPAREN",
		"COLON",
		"VERTBAR",
		"TILDE",
		"ESC",
		"UTF8",
		"UTFMB",
		"UTF0",
		"UTF1",
		"UTF2",
		"UTF3",
		"UTF4"
	};
	
	
	}
