// $ANTLR 2.7.4: "ACIItemChecker.g" -> "AntlrACIItemChecker.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.shared.ldap.aci;


import org.apache.directory.shared.ldap.name.NameComponentNormalizer;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated ACIItem checker.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class AntlrACIItemChecker extends antlr.LLkParser       implements AntlrACIItemCheckerTokenTypes
 {

    NameComponentNormalizer normalizer;
    
    /**
     * Creates a (normalizing) subordinate DnParser for parsing Names.
     * This method MUST be called for each instance while we cannot do
     * constructor overloading for this class.
     *
     * @return the DnParser to be used for parsing Names
     */
    public void init()
    {
    }

    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     */
    public void setNormalizer(NameComponentNormalizer normalizer)
    {
        this.normalizer = normalizer;
    }

protected AntlrACIItemChecker(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrACIItemChecker(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemChecker(TokenStream lexer) {
  this(lexer,1);
}

public AntlrACIItemChecker(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final void wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		
		
		{
		_loop460:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop460;
			}
			
		} while (true);
		}
		theACIItem();
		{
		_loop462:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop462;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
	}
	
	public final void theACIItem() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop465:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop465;
			}
			
		} while (true);
		}
		mainACIItemComponent();
		{
		_loop467:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop467;
			}
			
		} while (true);
		}
		{
		_loop473:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop470:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop470;
					}
					
				} while (true);
				}
				mainACIItemComponent();
				{
				_loop472:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop472;
					}
					
				} while (true);
				}
			}
			else {
				break _loop473;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_identificationTag:
		{
			aci_identificationTag();
			break;
		}
		case ID_precedence:
		{
			aci_precedence();
			break;
		}
		case ID_authenticationLevel:
		{
			aci_authenticationLevel();
			break;
		}
		case ID_itemOrUserFirst:
		{
			aci_itemOrUserFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
		
		
		match(ID_identificationTag);
		{
		int _cnt477=0;
		_loop477:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt477>=1 ) { break _loop477; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt477++;
		} while (true);
		}
		match(SAFEUTF8STRING);
	}
	
	public final void aci_precedence() throws RecognitionException, TokenStreamException {
		
		
		precedence();
	}
	
	public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		match(ID_authenticationLevel);
		{
		int _cnt484=0;
		_loop484:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt484>=1 ) { break _loop484; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt484++;
		} while (true);
		}
		authenticationLevel();
	}
	
	public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemOrUserFirst);
		{
		int _cnt488=0;
		_loop488:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt488>=1 ) { break _loop488; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt488++;
		} while (true);
		}
		itemOrUserFirst();
	}
	
	public final void precedence() throws RecognitionException, TokenStreamException {
		
		
		match(ID_precedence);
		{
		int _cnt481=0;
		_loop481:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt481>=1 ) { break _loop481; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt481++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_none:
		{
			match(ID_none);
			break;
		}
		case ID_simple:
		{
			match(ID_simple);
			break;
		}
		case ID_strong:
		{
			match(ID_strong);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_itemFirst:
		{
			itemFirst();
			break;
		}
		case ID_userFirst:
		{
			userFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemFirst);
		{
		_loop492:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop492;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop494:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop494;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop496:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop496;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_protectedItems:
		{
			protectedItems();
			{
			_loop499:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop499;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop501:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop501;
				}
				
			} while (true);
			}
			itemPermissions();
			break;
		}
		case ID_itemPermissions:
		{
			itemPermissions();
			{
			_loop503:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop503;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop505:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop505;
				}
				
			} while (true);
			}
			protectedItems();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop507:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop507;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userFirst() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userFirst);
		{
		_loop510:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop510;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop512:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop512;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop514:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop514;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_userClasses:
		{
			userClasses();
			{
			_loop517:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop517;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop519:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop519;
				}
				
			} while (true);
			}
			userPermissions();
			break;
		}
		case ID_userPermissions:
		{
			userPermissions();
			{
			_loop521:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop521;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop523:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop523;
				}
				
			} while (true);
			}
			userClasses();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop525:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop525;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItems() throws RecognitionException, TokenStreamException {
		
		
		match(ID_protectedItems);
		{
		_loop528:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop528;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop530:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop530;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ATTRIBUTE_VALUE_CANDIDATE:
		case RANGE_OF_VALUES_CANDIDATE:
		case ID_entry:
		case ID_allUserAttributeTypes:
		case ID_attributeType:
		case ID_allAttributeValues:
		case ID_allUserAttributeTypesAndValues:
		case ID_selfValue:
		case ID_maxValueCount:
		case ID_maxImmSub:
		case ID_restrictedBy:
		case ID_classes:
		{
			protectedItem();
			{
			_loop533:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop533;
				}
				
			} while (true);
			}
			{
			_loop539:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop536:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop536;
						}
						
					} while (true);
					}
					protectedItem();
					{
					_loop538:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop538;
						}
						
					} while (true);
					}
				}
				else {
					break _loop539;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void itemPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_itemPermissions);
		{
		int _cnt644=0;
		_loop644:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt644>=1 ) { break _loop644; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt644++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop646:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop646;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			itemPermission();
			{
			_loop649:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop649;
				}
				
			} while (true);
			}
			{
			_loop655:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop652:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop652;
						}
						
					} while (true);
					}
					itemPermission();
					{
					_loop654:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop654;
						}
						
					} while (true);
					}
				}
				else {
					break _loop655;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userClasses() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userClasses);
		{
		int _cnt685=0;
		_loop685:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt685>=1 ) { break _loop685; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt685++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop687:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop687;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_allUsers:
		case ID_thisEntry:
		case ID_name:
		case ID_userGroup:
		case ID_subtree:
		{
			userClass();
			{
			_loop690:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop690;
				}
				
			} while (true);
			}
			{
			_loop696:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop693:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop693;
						}
						
					} while (true);
					}
					userClass();
					{
					_loop695:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop695;
						}
						
					} while (true);
					}
				}
				else {
					break _loop696;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermissions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userPermissions);
		{
		int _cnt741=0;
		_loop741:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt741>=1 ) { break _loop741; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt741++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop743:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop743;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			userPermission();
			{
			_loop746:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop746;
				}
				
			} while (true);
			}
			{
			_loop752:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop749:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop749;
						}
						
					} while (true);
					}
					userPermission();
					{
					_loop751:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop751;
						}
						
					} while (true);
					}
				}
				else {
					break _loop752;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItem() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			entry();
			break;
		}
		case ID_allUserAttributeTypes:
		{
			allUserAttributeTypes();
			break;
		}
		case ID_attributeType:
		{
			attributeType();
			break;
		}
		case ID_allAttributeValues:
		{
			allAttributeValues();
			break;
		}
		case ID_allUserAttributeTypesAndValues:
		{
			allUserAttributeTypesAndValues();
			break;
		}
		case ATTRIBUTE_VALUE_CANDIDATE:
		{
			attributeValue();
			break;
		}
		case ID_selfValue:
		{
			selfValue();
			break;
		}
		case RANGE_OF_VALUES_CANDIDATE:
		{
			rangeOfValues();
			break;
		}
		case ID_maxValueCount:
		{
			maxValueCount();
			break;
		}
		case ID_maxImmSub:
		{
			maxImmSub();
			break;
		}
		case ID_restrictedBy:
		{
			restrictedBy();
			break;
		}
		case ID_classes:
		{
			classes();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void entry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_entry);
	}
	
	public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypes);
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		
		match(ID_attributeType);
		{
		int _cnt545=0;
		_loop545:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt545>=1 ) { break _loop545; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt545++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allAttributeValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allAttributeValues);
		{
		int _cnt548=0;
		_loop548:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt548>=1 ) { break _loop548; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt548++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUserAttributeTypesAndValues);
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		
		match(ATTRIBUTE_VALUE_CANDIDATE);
	}
	
	public final void selfValue() throws RecognitionException, TokenStreamException {
		
		
		match(ID_selfValue);
		{
		int _cnt553=0;
		_loop553:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt553>=1 ) { break _loop553; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt553++;
		} while (true);
		}
		attributeTypeSet();
	}
	
	public final void rangeOfValues() throws RecognitionException, TokenStreamException {
		
		
		match(RANGE_OF_VALUES_CANDIDATE);
	}
	
	public final void maxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxValueCount);
		{
		int _cnt557=0;
		_loop557:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt557>=1 ) { break _loop557; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt557++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop559:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop559;
			}
			
		} while (true);
		}
		aMaxValueCount();
		{
		_loop561:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop561;
			}
			
		} while (true);
		}
		{
		_loop567:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop564:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop564;
					}
					
				} while (true);
				}
				aMaxValueCount();
				{
				_loop566:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop566;
					}
					
				} while (true);
				}
			}
			else {
				break _loop567;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void maxImmSub() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maxImmSub);
		{
		int _cnt592=0;
		_loop592:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt592>=1 ) { break _loop592; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt592++;
		} while (true);
		}
		match(INTEGER);
	}
	
	public final void restrictedBy() throws RecognitionException, TokenStreamException {
		
		
		match(ID_restrictedBy);
		{
		int _cnt595=0;
		_loop595:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt595>=1 ) { break _loop595; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt595++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop597:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop597;
			}
			
		} while (true);
		}
		restrictedValue();
		{
		_loop599:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop599;
			}
			
		} while (true);
		}
		{
		_loop605:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop602:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop602;
					}
					
				} while (true);
				}
				restrictedValue();
				{
				_loop604:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop604;
					}
					
				} while (true);
				}
			}
			else {
				break _loop605;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void classes() throws RecognitionException, TokenStreamException {
		
		
		match(ID_classes);
		{
		int _cnt641=0;
		_loop641:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt641>=1 ) { break _loop641; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt641++;
		} while (true);
		}
		refinement();
	}
	
	public final void attributeTypeSet() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop630:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop630;
			}
			
		} while (true);
		}
		oid();
		{
		_loop632:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop632;
			}
			
		} while (true);
		}
		{
		_loop638:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop635:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop635;
					}
					
				} while (true);
				}
				oid();
				{
				_loop637:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop637;
					}
					
				} while (true);
				}
			}
			else {
				break _loop638;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void aMaxValueCount() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop570:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop570;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt573=0;
			_loop573:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt573>=1 ) { break _loop573; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt573++;
			} while (true);
			}
			oid();
			{
			_loop575:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop575;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop577:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop577;
				}
				
			} while (true);
			}
			match(ID_maxCount);
			{
			int _cnt579=0;
			_loop579:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt579>=1 ) { break _loop579; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt579++;
			} while (true);
			}
			match(INTEGER);
			break;
		}
		case ID_maxCount:
		{
			match(ID_maxCount);
			{
			int _cnt581=0;
			_loop581:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt581>=1 ) { break _loop581; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt581++;
			} while (true);
			}
			match(INTEGER);
			{
			_loop583:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop583;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop585:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop585;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt587=0;
			_loop587:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt587>=1 ) { break _loop587; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt587++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop589:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop589;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void oid() throws RecognitionException, TokenStreamException {
		
		
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void restrictedValue() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop608:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop608;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt611=0;
			_loop611:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt611>=1 ) { break _loop611; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt611++;
			} while (true);
			}
			oid();
			{
			_loop613:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop613;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop615:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop615;
				}
				
			} while (true);
			}
			match(ID_valuesIn);
			{
			int _cnt617=0;
			_loop617:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt617>=1 ) { break _loop617; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt617++;
			} while (true);
			}
			oid();
			break;
		}
		case ID_valuesIn:
		{
			match(ID_valuesIn);
			{
			int _cnt619=0;
			_loop619:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt619>=1 ) { break _loop619; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt619++;
			} while (true);
			}
			oid();
			{
			_loop621:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop621;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop623:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop623;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt625=0;
			_loop625:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt625>=1 ) { break _loop625; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt625++;
			} while (true);
			}
			oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop627:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop627;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void refinement() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			item();
			break;
		}
		case ID_and:
		{
			and();
			break;
		}
		case ID_or:
		{
			or();
			break;
		}
		case ID_not:
		{
			not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop658:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop658;
			}
			
		} while (true);
		}
		anyItemPermission();
		{
		_loop660:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop660;
			}
			
		} while (true);
		}
		{
		_loop666:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop663:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop663;
					}
					
				} while (true);
				}
				anyItemPermission();
				{
				_loop665:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop665;
					}
					
				} while (true);
				}
			}
			else {
				break _loop666;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyItemPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_userClasses:
		{
			userClasses();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
		
		
		match(ID_grantsAndDenials);
		{
		int _cnt670=0;
		_loop670:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt670>=1 ) { break _loop670; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt670++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop672:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop672;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_grantAdd:
		case ID_denyAdd:
		case ID_grantDiscloseOnError:
		case ID_denyDiscloseOnError:
		case ID_grantRead:
		case ID_denyRead:
		case ID_grantRemove:
		case ID_denyRemove:
		case ID_grantBrowse:
		case ID_denyBrowse:
		case ID_grantExport:
		case ID_denyExport:
		case ID_grantImport:
		case ID_denyImport:
		case ID_grantModify:
		case ID_denyModify:
		case ID_grantRename:
		case ID_denyRename:
		case ID_grantReturnDN:
		case ID_denyReturnDN:
		case ID_grantCompare:
		case ID_denyCompare:
		case ID_grantFilterMatch:
		case ID_denyFilterMatch:
		case ID_grantInvoke:
		case ID_denyInvoke:
		{
			grantAndDenial();
			{
			_loop675:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop675;
				}
				
			} while (true);
			}
			{
			_loop681:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop678:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop678;
						}
						
					} while (true);
					}
					grantAndDenial();
					{
					_loop680:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop680;
						}
						
					} while (true);
					}
				}
				else {
					break _loop681;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void grantAndDenial() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_grantAdd:
		{
			match(ID_grantAdd);
			break;
		}
		case ID_denyAdd:
		{
			match(ID_denyAdd);
			break;
		}
		case ID_grantDiscloseOnError:
		{
			match(ID_grantDiscloseOnError);
			break;
		}
		case ID_denyDiscloseOnError:
		{
			match(ID_denyDiscloseOnError);
			break;
		}
		case ID_grantRead:
		{
			match(ID_grantRead);
			break;
		}
		case ID_denyRead:
		{
			match(ID_denyRead);
			break;
		}
		case ID_grantRemove:
		{
			match(ID_grantRemove);
			break;
		}
		case ID_denyRemove:
		{
			match(ID_denyRemove);
			break;
		}
		case ID_grantBrowse:
		{
			match(ID_grantBrowse);
			break;
		}
		case ID_denyBrowse:
		{
			match(ID_denyBrowse);
			break;
		}
		case ID_grantExport:
		{
			match(ID_grantExport);
			break;
		}
		case ID_denyExport:
		{
			match(ID_denyExport);
			break;
		}
		case ID_grantImport:
		{
			match(ID_grantImport);
			break;
		}
		case ID_denyImport:
		{
			match(ID_denyImport);
			break;
		}
		case ID_grantModify:
		{
			match(ID_grantModify);
			break;
		}
		case ID_denyModify:
		{
			match(ID_denyModify);
			break;
		}
		case ID_grantRename:
		{
			match(ID_grantRename);
			break;
		}
		case ID_denyRename:
		{
			match(ID_denyRename);
			break;
		}
		case ID_grantReturnDN:
		{
			match(ID_grantReturnDN);
			break;
		}
		case ID_denyReturnDN:
		{
			match(ID_denyReturnDN);
			break;
		}
		case ID_grantCompare:
		{
			match(ID_grantCompare);
			break;
		}
		case ID_denyCompare:
		{
			match(ID_denyCompare);
			break;
		}
		case ID_grantFilterMatch:
		{
			match(ID_grantFilterMatch);
			break;
		}
		case ID_denyFilterMatch:
		{
			match(ID_denyFilterMatch);
			break;
		}
		case ID_grantInvoke:
		{
			match(ID_grantInvoke);
			break;
		}
		case ID_denyInvoke:
		{
			match(ID_denyInvoke);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void userClass() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_allUsers:
		{
			allUsers();
			break;
		}
		case ID_thisEntry:
		{
			thisEntry();
			break;
		}
		case ID_name:
		{
			name();
			break;
		}
		case ID_userGroup:
		{
			userGroup();
			break;
		}
		case ID_subtree:
		{
			subtree();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void allUsers() throws RecognitionException, TokenStreamException {
		
		
		match(ID_allUsers);
	}
	
	public final void thisEntry() throws RecognitionException, TokenStreamException {
		
		
		match(ID_thisEntry);
	}
	
	public final void name() throws RecognitionException, TokenStreamException {
		
		
		match(ID_name);
		{
		int _cnt702=0;
		_loop702:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt702>=1 ) { break _loop702; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt702++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop704:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop704;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop706:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop706;
			}
			
		} while (true);
		}
		{
		_loop712:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop709:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop709;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop711:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop711;
					}
					
				} while (true);
				}
			}
			else {
				break _loop712;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void userGroup() throws RecognitionException, TokenStreamException {
		
		
		match(ID_userGroup);
		{
		int _cnt715=0;
		_loop715:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt715>=1 ) { break _loop715; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt715++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop717:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop717;
			}
			
		} while (true);
		}
		distinguishedName();
		{
		_loop719:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop719;
			}
			
		} while (true);
		}
		{
		_loop725:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop722:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop722;
					}
					
				} while (true);
				}
				distinguishedName();
				{
				_loop724:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop724;
					}
					
				} while (true);
				}
			}
			else {
				break _loop725;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		
		match(ID_subtree);
		{
		int _cnt728=0;
		_loop728:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt728>=1 ) { break _loop728; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt728++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop730:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop730;
			}
			
		} while (true);
		}
		subtreeSpecification();
		{
		_loop732:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop732;
			}
			
		} while (true);
		}
		{
		_loop738:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop735:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop735;
					}
					
				} while (true);
				}
				subtreeSpecification();
				{
				_loop737:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop737;
					}
					
				} while (true);
				}
			}
			else {
				break _loop738;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void distinguishedName() throws RecognitionException, TokenStreamException {
		
		
		match(SAFEUTF8STRING);
	}
	
	public final void subtreeSpecification() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop767:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop767;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		{
			subtreeSpecificationComponent();
			{
			_loop770:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop770;
				}
				
			} while (true);
			}
			{
			_loop776:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop773:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop773;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop775:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop775;
						}
						
					} while (true);
					}
				}
				else {
					break _loop776;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userPermission() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop755:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop755;
			}
			
		} while (true);
		}
		anyUserPermission();
		{
		_loop757:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop757;
			}
			
		} while (true);
		}
		{
		_loop763:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop760:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop760;
					}
					
				} while (true);
				}
				anyUserPermission();
				{
				_loop762:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop762;
					}
					
				} while (true);
				}
			}
			else {
				break _loop763;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
	}
	
	public final void anyUserPermission() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_precedence:
		{
			precedence();
			break;
		}
		case ID_protectedItems:
		{
			protectedItems();
			break;
		}
		case ID_grantsAndDenials:
		{
			grantsAndDenials();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_base:
		{
			ss_base();
			break;
		}
		case ID_specificExclusions:
		{
			ss_specificExclusions();
			break;
		}
		case ID_minimum:
		{
			ss_minimum();
			break;
		}
		case ID_maximum:
		{
			ss_maximum();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		match(ID_base);
		{
		int _cnt780=0;
		_loop780:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt780>=1 ) { break _loop780; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt780++;
		} while (true);
		}
		distinguishedName();
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(ID_specificExclusions);
		{
		int _cnt783=0;
		_loop783:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt783>=1 ) { break _loop783; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt783++;
		} while (true);
		}
		specificExclusions();
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_minimum);
		{
		int _cnt809=0;
		_loop809:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt809>=1 ) { break _loop809; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt809++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		match(ID_maximum);
		{
		int _cnt812=0;
		_loop812:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt812>=1 ) { break _loop812; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt812++;
		} while (true);
		}
		baseDistance();
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop786:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop786;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop789:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop789;
				}
				
			} while (true);
			}
			{
			_loop795:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop792:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop792;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop794:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop794;
						}
						
					} while (true);
					}
				}
				else {
					break _loop795;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopBefore);
		{
		_loop799:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop799;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop801:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop801;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		match(ID_chopAfter);
		{
		_loop804:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop804;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop806:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop806;
			}
			
		} while (true);
		}
		distinguishedName();
	}
	
	public final void baseDistance() throws RecognitionException, TokenStreamException {
		
		
		match(INTEGER);
	}
	
	public final void item() throws RecognitionException, TokenStreamException {
		
		
		match(ID_item);
		{
		_loop820:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop820;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop822:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop822;
			}
			
		} while (true);
		}
		oid();
	}
	
	public final void and() throws RecognitionException, TokenStreamException {
		
		
		match(ID_and);
		{
		_loop825:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop825;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop827:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop827;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void or() throws RecognitionException, TokenStreamException {
		
		
		match(ID_or);
		{
		_loop830:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop830;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop832:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop832;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void not() throws RecognitionException, TokenStreamException {
		
		
		match(ID_not);
		{
		_loop835:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop835;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop837:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop837;
			}
			
		} while (true);
		}
		refinements();
	}
	
	public final void refinements() throws RecognitionException, TokenStreamException {
		
		
		match(OPEN_CURLY);
		{
		_loop840:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop840;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			refinement();
			{
			_loop843:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop843;
				}
				
			} while (true);
			}
			{
			_loop849:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop846:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop846;
						}
						
					} while (true);
					}
					refinement();
					{
					_loop848:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop848;
						}
						
					} while (true);
					}
				}
				else {
					break _loop849;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ATTRIBUTE_VALUE_CANDIDATE",
		"RANGE_OF_VALUES_CANDIDATE",
		"SP",
		"OPEN_CURLY",
		"SEP",
		"CLOSE_CURLY",
		"\"identificationTag\"",
		"SAFEUTF8STRING",
		"\"precedence\"",
		"INTEGER",
		"\"authenticationLevel\"",
		"\"none\"",
		"\"simple\"",
		"\"strong\"",
		"\"itemOrUserFirst\"",
		"\"itemFirst\"",
		"COLON",
		"\"userFirst\"",
		"\"protectedItems\"",
		"\"entry\"",
		"\"allUserAttributeTypes\"",
		"\"attributeType\"",
		"\"allAttributeValues\"",
		"\"allUserAttributeTypesAndValues\"",
		"\"selfValue\"",
		"\"maxValueCount\"",
		"\"type\"",
		"\"maxCount\"",
		"\"maxImmSub\"",
		"\"restrictedBy\"",
		"\"valuesIn\"",
		"\"classes\"",
		"\"itemPermissions\"",
		"\"grantsAndDenials\"",
		"\"grantAdd\"",
		"\"denyAdd\"",
		"\"grantDiscloseOnError\"",
		"\"denyDiscloseOnError\"",
		"\"grantRead\"",
		"\"denyRead\"",
		"\"grantRemove\"",
		"\"denyRemove\"",
		"\"grantBrowse\"",
		"\"denyBrowse\"",
		"\"grantExport\"",
		"\"denyExport\"",
		"\"grantImport\"",
		"\"denyImport\"",
		"\"grantModify\"",
		"\"denyModify\"",
		"\"grantRename\"",
		"\"denyRename\"",
		"\"grantReturnDN\"",
		"\"denyReturnDN\"",
		"\"grantCompare\"",
		"\"denyCompare\"",
		"\"grantFilterMatch\"",
		"\"denyFilterMatch\"",
		"\"grantInvoke\"",
		"\"denyInvoke\"",
		"\"userClasses\"",
		"\"allUsers\"",
		"\"thisEntry\"",
		"\"name\"",
		"\"userGroup\"",
		"\"subtree\"",
		"\"userPermissions\"",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"\"FALSE\"",
		"\"TRUE\"",
		"\"level\"",
		"\"basicLevels\"",
		"\"localQualifier\"",
		"\"signed\"",
		"\"rangeOfValues\"",
		"\"specificationFilter\"",
		"SAFEUTF8CHAR",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"HYPHEN",
		"DOT",
		"INTEGER_OR_NUMERICOID",
		"FILTER",
		"FILTER_VALUE"
	};
	
	
	}
