// $ANTLR 2.7.4: "openldap.g" -> "antlrOpenLdapSchemaParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
/*
 * Keep the semicolon right next to the package name or else there will be a
 * bug that comes into the foreground in the new antlr release.
 */
package org.apache.directory.shared.ldap.schema.parser;

import java.util.* ;
import org.apache.directory.shared.ldap.schema.*;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

public class antlrOpenLdapSchemaParser extends antlr.LLkParser       implements antlrOpenLdapSchemaTokenTypes
 {

    public static final String[] EMPTY = new String[0];

    private List attributeTypes = new ArrayList();
    private List objectClasses = new ArrayList();
    private ParserMonitor monitor = null;


    // ------------------------------------------------------------------------
    // Public Methods
    // ------------------------------------------------------------------------


    public void clear()
    {
        attributeTypes.clear();
        objectClasses.clear();
    }


    public List getAttributeTypes()
    {
        return Collections.unmodifiableList( attributeTypes );
    }


    public List getObjectClasses()
    {
        return Collections.unmodifiableList( objectClasses );
    }


    public void setParserMonitor( ParserMonitor monitor )
    {
        this.monitor = monitor;
    }


    // ------------------------------------------------------------------------
    // Private Methods
    // ------------------------------------------------------------------------


    private void matchedProduction( String msg )
    {
        if ( null != monitor )
        {
            monitor.matchedProduction( msg );
        }
    }

protected antlrOpenLdapSchemaParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public antlrOpenLdapSchemaParser(TokenBuffer tokenBuf) {
  this(tokenBuf,5);
}

protected antlrOpenLdapSchemaParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public antlrOpenLdapSchemaParser(TokenStream lexer) {
  this(lexer,5);
}

public antlrOpenLdapSchemaParser(ParserSharedInputState state) {
  super(state,5);
  tokenNames = _tokenNames;
}

	public final void parseSchema() throws RecognitionException, TokenStreamException {
		
		
		
		
		{
		_loop945:
		do {
			switch ( LA(1)) {
			case LITERAL_attributetype:
			{
				attributeType();
				break;
			}
			case LITERAL_objectclass:
			{
				objectClass();
				break;
			}
			default:
			{
				break _loop945;
			}
			}
		} while (true);
		}
		match(LITERAL_END);
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		
		matchedProduction( "attributeType()" );
		AttributeTypeLiteral type = null;
		
		
		match(LITERAL_attributetype);
		match(OPEN_PAREN);
		oid = LT(1);
		match(NUMERICOID);
		
		type = new AttributeTypeLiteral( oid.getText() );
		
		{
		switch ( LA(1)) {
		case LITERAL_NAME:
		{
			names(type);
			break;
		}
		case CLOSE_PAREN:
		case DESC:
		case SYNTAX:
		case LITERAL_OBSOLETE:
		case LITERAL_SUP:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_EQUALITY:
		case LITERAL_SUBSTR:
		case LITERAL_ORDERING:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case DESC:
		{
			desc(type);
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case LITERAL_OBSOLETE:
		case LITERAL_SUP:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_EQUALITY:
		case LITERAL_SUBSTR:
		case LITERAL_ORDERING:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_OBSOLETE:
		{
			match(LITERAL_OBSOLETE);
			type.setObsolete( true );
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case LITERAL_SUP:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_EQUALITY:
		case LITERAL_SUBSTR:
		case LITERAL_ORDERING:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_SUP:
		{
			superior(type);
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_EQUALITY:
		case LITERAL_SUBSTR:
		case LITERAL_ORDERING:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_EQUALITY:
		{
			equality(type);
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_SUBSTR:
		case LITERAL_ORDERING:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_ORDERING:
		{
			ordering(type);
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_SUBSTR:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_SUBSTR:
		{
			substr(type);
			break;
		}
		case CLOSE_PAREN:
		case SYNTAX:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case SYNTAX:
		{
			syntax(type);
			break;
		}
		case CLOSE_PAREN:
		case 28:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 28:
		{
			match(28);
			type.setSingleValue( true );
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_COLLECTIVE:
		case 30:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_COLLECTIVE:
		{
			match(LITERAL_COLLECTIVE);
			type.setCollective( true );
			break;
		}
		case CLOSE_PAREN:
		case 30:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case 30:
		{
			match(30);
			type.setNoUserModification( true );
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_USAGE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_USAGE:
		{
			usage(type);
			break;
		}
		case CLOSE_PAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_PAREN);
		
		attributeTypes.add( type );
		
	}
	
	public final void objectClass() throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		
		matchedProduction( "objectClass()" );
		ObjectClassLiteral objectClass = null;
		
		
		match(LITERAL_objectclass);
		match(OPEN_PAREN);
		oid = LT(1);
		match(NUMERICOID);
		
		objectClass = new ObjectClassLiteral( oid.getText() );
		
		{
		switch ( LA(1)) {
		case LITERAL_NAME:
		{
			objectClassNames(objectClass);
			break;
		}
		case CLOSE_PAREN:
		case DESC:
		case LITERAL_OBSOLETE:
		case LITERAL_ABSTRACT:
		case LITERAL_STRUCTURAL:
		case LITERAL_AUXILIARY:
		case LITERAL_MAY:
		case LITERAL_MUST:
		case LITERAL_SUP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case DESC:
		{
			objectClassDesc(objectClass);
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_OBSOLETE:
		case LITERAL_ABSTRACT:
		case LITERAL_STRUCTURAL:
		case LITERAL_AUXILIARY:
		case LITERAL_MAY:
		case LITERAL_MUST:
		case LITERAL_SUP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_OBSOLETE:
		{
			match(LITERAL_OBSOLETE);
			objectClass.setObsolete( true );
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_ABSTRACT:
		case LITERAL_STRUCTURAL:
		case LITERAL_AUXILIARY:
		case LITERAL_MAY:
		case LITERAL_MUST:
		case LITERAL_SUP:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_SUP:
		{
			objectClassSuperiors(objectClass);
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_ABSTRACT:
		case LITERAL_STRUCTURAL:
		case LITERAL_AUXILIARY:
		case LITERAL_MAY:
		case LITERAL_MUST:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_ABSTRACT:
		{
			match(LITERAL_ABSTRACT);
			objectClass.setClassType( ObjectClassTypeEnum.ABSTRACT );
			break;
		}
		case LITERAL_STRUCTURAL:
		{
			match(LITERAL_STRUCTURAL);
			objectClass.setClassType( ObjectClassTypeEnum.STRUCTURAL );
			break;
		}
		case LITERAL_AUXILIARY:
		{
			match(LITERAL_AUXILIARY);
			objectClass.setClassType( ObjectClassTypeEnum.AUXILIARY );
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_MAY:
		case LITERAL_MUST:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_MUST:
		{
			must(objectClass);
			break;
		}
		case CLOSE_PAREN:
		case LITERAL_MAY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LITERAL_MAY:
		{
			may(objectClass);
			break;
		}
		case CLOSE_PAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_PAREN);
		
		objectClasses.add( objectClass );
		
	}
	
	public final void objectClassNames(
		ObjectClassLiteral objectClass
	) throws RecognitionException, TokenStreamException {
		
		Token  id0 = null;
		Token  id1 = null;
		Token  id2 = null;
		
		matchedProduction( "names(ObjectClassLiteral)" ) ;
		ArrayList list = new ArrayList();
		
		
		{
		match(LITERAL_NAME);
		{
		switch ( LA(1)) {
		case QUOTE:
		{
			match(QUOTE);
			id0 = LT(1);
			match(IDENTIFIER);
			match(QUOTE);
			
			list.add( id0.getText() );
			
			break;
		}
		case OPEN_PAREN:
		{
			{
			match(OPEN_PAREN);
			match(QUOTE);
			id1 = LT(1);
			match(IDENTIFIER);
			
			list.add( id1.getText() );
			
			match(QUOTE);
			{
			_loop970:
			do {
				if ((LA(1)==QUOTE)) {
					match(QUOTE);
					id2 = LT(1);
					match(IDENTIFIER);
					match(QUOTE);
					
					list.add( id2.getText() );
					
				}
				else {
					break _loop970;
				}
				
			} while (true);
			}
			match(CLOSE_PAREN);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		
		objectClass.setNames( ( String[] ) list.toArray( EMPTY ) );
		
	}
	
	public final void objectClassDesc(
		ObjectClassLiteral objectClass
	) throws RecognitionException, TokenStreamException {
		
		Token  d = null;
		
		matchedProduction( "desc(ObjectClassLiteral)" ) ;
		
		
		d = LT(1);
		match(DESC);
		
		String desc = d.getText().split( "'" )[1];
		String[] quoted = desc.split( "\"" );
		
		if ( quoted.length == 1 )
		{
		objectClass.setDescription( desc );
		}
		else
		{
		StringBuffer buf = new StringBuffer();
		for ( int ii = 0; ii < quoted.length; ii++ )
		{
		if ( ii < quoted.length - 1 )
		{
		buf.append( quoted[ii] ).append( "\\" ).append( "\"" );
		}
		else
		{
		buf.append( quoted[ii] );
		}
		}
		
		objectClass.setDescription( buf.toString() );
		}
		
	}
	
	public final void objectClassSuperiors(
		ObjectClassLiteral objectClass
	) throws RecognitionException, TokenStreamException {
		
		
		matchedProduction( "objectClassSuperiors(ObjectClassLiteral)" ) ;
		ArrayList list = null;
		
		
		match(LITERAL_SUP);
		list=woidlist();
		
		objectClass.setSuperiors( ( String[] ) list.toArray( EMPTY ) );
		
	}
	
	public final void must(
		ObjectClassLiteral objectClass
	) throws RecognitionException, TokenStreamException {
		
		
		matchedProduction( "must(ObjectClassLiteral)" ) ;
		ArrayList list = null;
		
		
		match(LITERAL_MUST);
		list=woidlist();
		
		objectClass.setMust( ( String[] ) list.toArray( EMPTY ) );
		
	}
	
	public final void may(
		ObjectClassLiteral objectClass
	) throws RecognitionException, TokenStreamException {
		
		
		matchedProduction( "may(ObjectClassLiteral)" ) ;
		ArrayList list = null;
		
		
		match(LITERAL_MAY);
		list=woidlist();
		
		objectClass.setMay( ( String[] ) list.toArray( EMPTY ) );
		
	}
	
	public final ArrayList  woidlist() throws RecognitionException, TokenStreamException {
		ArrayList list;
		
		
		matchedProduction( "woidlist()" ) ;
		list = new ArrayList( 2 );
		String oid = null;
		
		
		{
		switch ( LA(1)) {
		case NUMERICOID:
		case IDENTIFIER:
		{
			oid=woid();
			list.add( oid );
			break;
		}
		case OPEN_PAREN:
		{
			{
			match(OPEN_PAREN);
			oid=woid();
			list.add( oid );
			{
			_loop963:
			do {
				if ((LA(1)==DOLLAR)) {
					match(DOLLAR);
					oid=woid();
					list.add( oid );
				}
				else {
					break _loop963;
				}
				
			} while (true);
			}
			match(CLOSE_PAREN);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return list;
	}
	
	public final String  woid() throws RecognitionException, TokenStreamException {
		String oid;
		
		Token  opt1 = null;
		Token  opt2 = null;
		
		oid = null;
		matchedProduction( "woid()" ) ;
		
		
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			opt1 = LT(1);
			match(NUMERICOID);
			
			oid = opt1.getText();
			
			break;
		}
		case IDENTIFIER:
		{
			opt2 = LT(1);
			match(IDENTIFIER);
			
			oid = opt2.getText();
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return oid;
	}
	
	public final void names(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  id0 = null;
		Token  id1 = null;
		
		matchedProduction( "names(AttributeTypeLiteral)" ) ;
		ArrayList list = new ArrayList();
		
		
		match(LITERAL_NAME);
		{
		switch ( LA(1)) {
		case QUOTE:
		{
			match(QUOTE);
			id0 = LT(1);
			match(IDENTIFIER);
			match(QUOTE);
			list.add( id0.getText() );
			break;
		}
		case OPEN_PAREN:
		{
			{
			match(OPEN_PAREN);
			{
			int _cnt997=0;
			_loop997:
			do {
				if ((LA(1)==QUOTE)) {
					match(QUOTE);
					id1 = LT(1);
					match(IDENTIFIER);
					
					list.add( id1.getText() );
					
					match(QUOTE);
				}
				else {
					if ( _cnt997>=1 ) { break _loop997; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt997++;
			} while (true);
			}
			match(CLOSE_PAREN);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		type.setNames( ( String[] ) list.toArray( EMPTY ) );
		
	}
	
	public final void desc(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  d = null;
		
		matchedProduction( "desc(AttributeTypeLiteral)" ) ;
		
		
		d = LT(1);
		match(DESC);
		
		String desc = d.getText().split( "'" )[1];
		String[] quoted = desc.split( "\"" );
		
		if ( quoted.length == 1 )
		{
		type.setDescription( desc );
		}
		else
		{
		StringBuffer buf = new StringBuffer();
		for ( int ii = 0; ii < quoted.length; ii++ )
		{
		if ( ii < quoted.length - 1 )
		{
		buf.append( quoted[ii] ).append( "\\" ).append( "\"" );
		}
		else
		{
		buf.append( quoted[ii] );
		}
		}
		
		type.setDescription( buf.toString() );
		}
		
	}
	
	public final void superior(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		Token  id = null;
		
		matchedProduction( "superior(AttributeTypeLiteral)" ) ;
		
		
		match(LITERAL_SUP);
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			oid = LT(1);
			match(NUMERICOID);
			
			type.setSuperior( oid.getText() );
			
			break;
		}
		case IDENTIFIER:
		{
			id = LT(1);
			match(IDENTIFIER);
			
			type.setSuperior( id.getText() );
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void equality(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		Token  id = null;
		
		matchedProduction( "equality(AttributeTypeLiteral)" ) ;
		
		
		match(LITERAL_EQUALITY);
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			oid = LT(1);
			match(NUMERICOID);
			
			type.setEquality( oid.getText() );
			
			break;
		}
		case IDENTIFIER:
		{
			id = LT(1);
			match(IDENTIFIER);
			
			type.setEquality( id.getText() );
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void ordering(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		Token  id = null;
		
		matchedProduction( "ordering(AttributeTypeLiteral)" ) ;
		
		
		match(LITERAL_ORDERING);
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			oid = LT(1);
			match(NUMERICOID);
			
			type.setOrdering( oid.getText() );
			
			break;
		}
		case IDENTIFIER:
		{
			id = LT(1);
			match(IDENTIFIER);
			
			type.setOrdering( id.getText() );
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void substr(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  oid = null;
		Token  id = null;
		
		matchedProduction( "substr(AttributeTypeLiteral)" ) ;
		
		
		match(LITERAL_SUBSTR);
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			oid = LT(1);
			match(NUMERICOID);
			
			type.setSubstr( oid.getText() );
			
			break;
		}
		case IDENTIFIER:
		{
			id = LT(1);
			match(IDENTIFIER);
			
			type.setSubstr( id.getText() );
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	public final void syntax(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		matchedProduction( "syntax(AttributeTypeLiteral)" ) ;
		
		
		token = LT(1);
		match(SYNTAX);
		
		String[] comps = token.getText().split( " " );
		
		int index = comps[1].indexOf( "{" );
		if ( index == -1 )
		{
		type.setSyntax( comps[1] );
		return;
		}
		
		String oid = comps[1].substring( 0, index );
		String length = comps[1].substring( index + 1, comps[1].length() - 1 );
		
		type.setSyntax( oid );
		type.setLength( Integer.parseInt( length ) );
		
	}
	
	public final void usage(
		AttributeTypeLiteral type
	) throws RecognitionException, TokenStreamException {
		
		
		matchedProduction( "usage(AttributeTypeLiteral)" ) ;
		
		
		match(LITERAL_USAGE);
		{
		switch ( LA(1)) {
		case LITERAL_userApplications:
		{
			match(LITERAL_userApplications);
			type.setUsage( UsageEnum.USER_APPLICATIONS );
			break;
		}
		case LITERAL_directoryOperation:
		{
			match(LITERAL_directoryOperation);
			type.setUsage( UsageEnum.DIRECTORY_OPERATION );
			break;
		}
		case LITERAL_distributedOperation:
		{
			match(LITERAL_distributedOperation);
			type.setUsage( UsageEnum.DISTRIBUTED_OPERATION );
			break;
		}
		case LITERAL_dSAOperation:
		{
			match(LITERAL_dSAOperation);
			type.setUsage( UsageEnum.DSA_OPERATION );
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"WS",
		"QUOTE",
		"DIGIT",
		"DOLLAR",
		"OPEN_PAREN",
		"CLOSE_PAREN",
		"OPEN_BRACKET",
		"CLOSE_BRACKET",
		"NUMERIC_STRING",
		"NUMERICOID",
		"IDENTIFIER",
		"DESC",
		"SYNTAX",
		"\"END\"",
		"\"objectclass\"",
		"\"OBSOLETE\"",
		"\"ABSTRACT\"",
		"\"STRUCTURAL\"",
		"\"AUXILIARY\"",
		"\"MAY\"",
		"\"MUST\"",
		"\"SUP\"",
		"\"NAME\"",
		"\"attributetype\"",
		"\"SINGLE-VALUE\"",
		"\"COLLECTIVE\"",
		"\"NO-USER-MODIFICATION\"",
		"\"EQUALITY\"",
		"\"SUBSTR\"",
		"\"ORDERING\"",
		"\"USAGE\"",
		"\"userApplications\"",
		"\"directoryOperation\"",
		"\"distributedOperation\"",
		"\"dSAOperation\""
	};
	
	
	}
