// $ANTLR 2.7.4: "openldap.g" -> "antlrOpenLdapSchemaLexer.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
/*
 * Keep the semicolon right next to the package name or else there will be a
 * bug that comes into the foreground in the new antlr release.
 */
package org.apache.directory.shared.ldap.schema.parser;

import java.util.* ;
import org.apache.directory.shared.ldap.schema.*;


public interface antlrOpenLdapSchemaTokenTypes {
	int EOF = 1;
	int NULL_TREE_LOOKAHEAD = 3;
	int WS = 4;
	int QUOTE = 5;
	int DIGIT = 6;
	int DOLLAR = 7;
	int OPEN_PAREN = 8;
	int CLOSE_PAREN = 9;
	int OPEN_BRACKET = 10;
	int CLOSE_BRACKET = 11;
	int NUMERIC_STRING = 12;
	int NUMERICOID = 13;
	int IDENTIFIER = 14;
	int DESC = 15;
	int SYNTAX = 16;
	int LITERAL_END = 17;
	int LITERAL_objectclass = 18;
	int LITERAL_OBSOLETE = 19;
	int LITERAL_ABSTRACT = 20;
	int LITERAL_STRUCTURAL = 21;
	int LITERAL_AUXILIARY = 22;
	int LITERAL_MAY = 23;
	int LITERAL_MUST = 24;
	int LITERAL_SUP = 25;
	int LITERAL_NAME = 26;
	int LITERAL_attributetype = 27;
	// "SINGLE-VALUE" = 28
	int LITERAL_COLLECTIVE = 29;
	// "NO-USER-MODIFICATION" = 30
	int LITERAL_EQUALITY = 31;
	int LITERAL_SUBSTR = 32;
	int LITERAL_ORDERING = 33;
	int LITERAL_USAGE = 34;
	int LITERAL_userApplications = 35;
	int LITERAL_directoryOperation = 36;
	int LITERAL_distributedOperation = 37;
	int LITERAL_dSAOperation = 38;
}
