// $ANTLR 2.7.4: "schema.g" -> "AntlrSchemaParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;


public interface AntlrSchemaTokenTypes {
	int EOF = 1;
	int NULL_TREE_LOOKAHEAD = 3;
	int WHSP = 4;
	int LPAR = 5;
	int RPAR = 6;
	int QUOTE = 7;
	int DOLLAR = 8;
	int LBRACKET = 9;
	int RBRACKET = 10;
	int LEN = 11;
	int SINGLE_VALUE = 12;
	int COLLECTIVE = 13;
	int NO_USER_MODIFICATION = 14;
	int OBSOLETE = 15;
	int ABSTRACT = 16;
	int STRUCTURAL = 17;
	int AUXILIARY = 18;
	int STARTNUMERICOID = 19;
	int NAME = 20;
	int DESC = 21;
	int SUP = 22;
	int MUST = 23;
	int MAY = 24;
	int AUX = 25;
	int NOT = 26;
	int FORM = 27;
	int OC = 28;
	int EQUALITY = 29;
	int ORDERING = 30;
	int SUBSTR = 31;
	int SYNTAX = 32;
	int APPLIES = 33;
	int EXTENSION = 34;
	int FQCN = 35;
	int BYTECODE = 36;
	int VALUES = 37;
	int VALUE = 38;
	int UNQUOTED_STRING = 39;
	int QUOTED_STRING = 40;
	int FQCN_VALUE = 41;
	int FQCN_IDENTIFIER = 42;
	int FQCN_LETTER = 43;
	int FQCN_LETTERORDIGIT = 44;
	int BYTECODE_VALUE = 45;
	int USAGE = 46;
	int USER_APPLICATIONS = 47;
	int DIRECTORY_OPERATION = 48;
	int DISTRIBUTED_OPERATION = 49;
	int DSA_OPERATION = 50;
}
