// $ANTLR 2.7.4: "schema-value.g" -> "AntlrSchemaValueParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.List;
import java.util.ArrayList;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * An antlr generated schema parser. This is a sub-parser used to parse
 * numericoid, oid, oids, qdescr, qdescrs according to RFC4512.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class AntlrSchemaValueParser extends antlr.LLkParser       implements AntlrSchemaValueTokenTypes
 {

protected AntlrSchemaValueParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrSchemaValueParser(TokenBuffer tokenBuf) {
  this(tokenBuf,3);
}

protected AntlrSchemaValueParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrSchemaValueParser(TokenStream lexer) {
  this(lexer,3);
}

public AntlrSchemaValueParser(ParserSharedInputState state) {
  super(state,3);
  tokenNames = _tokenNames;
}

/**
     * noidlen = numericoid [ LCURLY len RCURLY ]
     * len = number
     */
	public final AntlrSchemaParser.NoidLen  noidlen() throws RecognitionException, TokenStreamException {
		AntlrSchemaParser.NoidLen noidlen = new AntlrSchemaParser.NoidLen();
		
		Token  o = null;
		Token  l = null;
		
		{
		o = LT(1);
		match(NUMERICOID);
		noidlen.noid = o.getText();
		{
		switch ( LA(1)) {
		case LEN:
		{
			l = LT(1);
			match(LEN);
			noidlen.len = Integer.parseInt(l.getText());
			break;
		}
		case EOF:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		return noidlen;
	}
	
/**
     * numericoid = number 1*( DOT number )
     */
	public final String  numericoid() throws RecognitionException, TokenStreamException {
		String numericoid=null;
		
		Token  n = null;
		
		{
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case NUMERICOID:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		n = LT(1);
		match(NUMERICOID);
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case EOF:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		numericoid = n.getText();
		}
		return numericoid;
	}
	
/**
     * oid = descr / numericoid
     * numericoid = number 1*( DOT number )
     * descr = keystring
     * keystring = leadkeychar *keychar
     * leadkeychar = ALPHA
     * keychar = ALPHA / DIGIT / HYPHEN
     * number  = DIGIT / ( LDIGIT 1*DIGIT )
     *
     */
	public final String  oid() throws RecognitionException, TokenStreamException {
		String oid=null;
		
		Token  n = null;
		Token  d = null;
		
		{
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case NUMERICOID:
		case DESCR:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case NUMERICOID:
		{
			n = LT(1);
			match(NUMERICOID);
			oid = n.getText();
			break;
		}
		case DESCR:
		{
			d = LT(1);
			match(DESCR);
			oid = d.getText();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case EOF:
		case RPAR:
		case DOLLAR:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		return oid;
	}
	
/**
     * oids = oid / ( LPAREN WSP oidlist WSP RPAREN )
     * oidlist = oid *( WSP DOLLAR WSP oid )
     */
	public final List<String>  oids() throws RecognitionException, TokenStreamException {
		List<String> oids;
		
		
		oids = new ArrayList<String>();
		String oid = null;
		
		
		{
		switch ( LA(1)) {
		case SP:
		case NUMERICOID:
		case DESCR:
		{
			{
			oid=oid();
			oids.add(oid);
			}
			break;
		}
		case LPAR:
		{
			{
			match(LPAR);
			oid=oid();
			oids.add(oid);
			{
			_loop1092:
			do {
				if ((LA(1)==DOLLAR)) {
					match(DOLLAR);
					oid=oid();
					oids.add(oid);
				}
				else {
					break _loop1092;
				}
				
			} while (true);
			}
			match(RPAR);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return oids;
	}
	
/**
     * qdescr = SQUOTE descr SQUOTE
     */
	public final String  qdescr() throws RecognitionException, TokenStreamException {
		String qdescr=null;
		
		Token  d = null;
		
		{
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case QUOTE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(QUOTE);
		d = LT(1);
		match(DESCR);
		qdescr = d.getText();
		match(QUOTE);
		}
		return qdescr;
	}
	
/**
     * qdescrs = qdescr / ( LPAREN WSP qdescrlist WSP RPAREN )
     * qdescrlist = [ qdescr *( SP qdescr ) ]
     */
	public final List<String>  qdescrs() throws RecognitionException, TokenStreamException {
		List<String> qdescrs;
		
		
			qdescrs = new ArrayList<String>();
		String qdescr = null;
		
		
		{
		switch ( LA(1)) {
		case SP:
		case QUOTE:
		{
			{
			qdescr=qdescr();
			qdescrs.add(qdescr);
			}
			break;
		}
		case LPAR:
		{
			{
			match(LPAR);
			qdescr=qdescr();
			qdescrs.add(qdescr);
			{
			_loop1101:
			do {
				if ((LA(1)==SP) && (LA(2)==SP||LA(2)==QUOTE)) {
					match(SP);
					qdescr=qdescr();
					qdescrs.add(qdescr);
				}
				else {
					break _loop1101;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case SP:
			{
				match(SP);
				break;
			}
			case RPAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(RPAR);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return qdescrs;
	}
	
/**
     * ruleid = number
     * number  = DIGIT / ( LDIGIT 1*DIGIT )
     *
     */
	public final Integer  ruleid() throws RecognitionException, TokenStreamException {
		Integer ruleid=null;
		
		Token  n = null;
		
		{
		{
		switch ( LA(1)) {
		case SP:
		{
			match(SP);
			break;
		}
		case NUMBER:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		n = LT(1);
		match(NUMBER);
		ruleid = Integer.parseInt(n.getText());
		}
		return ruleid;
	}
	
/**
     * ruleids = ruleid / ( LPAREN WSP ruleidlist WSP RPAREN )
     * ruleidlist = ruleid *( SP ruleid )
     */
	public final List<Integer>  ruleids() throws RecognitionException, TokenStreamException {
		List<Integer> ruleids;
		
		
		ruleids = new ArrayList<Integer>();
		Integer ruleid = null;
		
		
		{
		switch ( LA(1)) {
		case SP:
		case NUMBER:
		{
			{
			ruleid=ruleid();
			ruleids.add(ruleid);
			}
			break;
		}
		case LPAR:
		{
			{
			match(LPAR);
			ruleid=ruleid();
			ruleids.add(ruleid);
			{
			_loop1111:
			do {
				if ((LA(1)==SP) && (LA(2)==SP||LA(2)==NUMBER)) {
					match(SP);
					ruleid=ruleid();
					ruleids.add(ruleid);
				}
				else {
					break _loop1111;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case SP:
			{
				match(SP);
				break;
			}
			case RPAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(RPAR);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		return ruleids;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"SP",
		"LPAR",
		"RPAR",
		"LDIGIT",
		"DIGIT",
		"NUMBER",
		"NUMERICOID",
		"QUOTE",
		"DOLLAR",
		"LCURLY",
		"RCURLY",
		"DESCR",
		"LEN",
		"NUMBER_OR_NUMERICOID"
	};
	
	
	}
