/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.voice;

import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertInfo;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.plugin.alert.voice.VoiceParam;
import org.apache.dolphinscheduler.plugin.alert.voice.VoiceSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VoiceAlertChannel
implements AlertChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoiceAlertChannel.class);

    public AlertResult process(AlertInfo info) {
        Map paramsMap = info.getAlertParams();
        if (null == paramsMap) {
            return new AlertResult("false", "aliyun-voice params is null");
        }
        VoiceParam voiceParam = this.buildVoiceParam(paramsMap);
        return new VoiceSender(voiceParam).send();
    }

    public VoiceParam buildVoiceParam(Map<String, String> paramsMap) {
        String calledNumber = paramsMap.get("calledNumber");
        String calledShowNumber = paramsMap.get("calledShowNumber");
        String ttsCode = paramsMap.get("ttsCode");
        VoiceParam param = new VoiceParam();
        param.setCalledNumber(calledNumber);
        param.setCalledShowNumber(calledShowNumber);
        param.setTtsCode(ttsCode);
        VoiceParam.Connection connection = new VoiceParam.Connection();
        String address = paramsMap.get("address");
        String accessKeyId = paramsMap.get("accessKeyId");
        String accessKeySecret = paramsMap.get("accessKeySecret");
        connection.setAddress(address);
        connection.setAccessKeyId(accessKeyId);
        connection.setAccessKeySecret(accessKeySecret);
        param.setConnection(connection);
        param.setOutId(calledShowNumber);
        return param;
    }
}

