/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.voice;

import com.aliyun.dyvmsapi20170525.Client;
import com.aliyun.dyvmsapi20170525.models.SingleCallByTtsRequest;
import com.aliyun.dyvmsapi20170525.models.SingleCallByTtsResponse;
import com.aliyun.dyvmsapi20170525.models.SingleCallByTtsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.plugin.alert.voice.VoiceParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VoiceSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoiceSender.class);
    private VoiceParam voiceParam;

    public VoiceSender(VoiceParam voiceParam) {
        this.voiceParam = voiceParam;
    }

    public AlertResult send() {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        try {
            Client client = this.createClient(this.voiceParam.getConnection());
            SingleCallByTtsRequest singleCallByTtsRequest = new SingleCallByTtsRequest().setCalledNumber(this.voiceParam.getCalledNumber()).setTtsCode(this.voiceParam.getTtsCode()).setOutId(this.voiceParam.getOutId());
            RuntimeOptions runtime = new RuntimeOptions();
            SingleCallByTtsResponse response = client.singleCallByTtsWithOptions(singleCallByTtsRequest, runtime);
            if (response == null) {
                alertResult.setMessage("aliyun-vocie response is null");
                return alertResult;
            }
            SingleCallByTtsResponseBody body = response.getBody();
            if (body.code.equalsIgnoreCase("ok")) {
                alertResult.setStatus("true");
                alertResult.setMessage(body.getCallId());
            } else {
                alertResult.setMessage(body.getMessage());
            }
        }
        catch (Exception e) {
            log.error("send aliyun vocie error.", (Throwable)e);
            alertResult.setMessage(e.getMessage());
        }
        return alertResult;
    }

    private Client createClient(VoiceParam.Connection conn) throws Exception {
        Config config = new Config().setAccessKeyId(conn.getAccessKeyId()).setAccessKeySecret(conn.getAccessKeySecret());
        config.endpoint = conn.getAddress();
        return new Client(config);
    }

    public VoiceParam getVoidcePara() {
        return this.voiceParam;
    }

    public void setVoidcePara(VoiceParam voidcePara) {
        this.voiceParam = voidcePara;
    }
}

