/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.dingtalk;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DingTalkSender {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkSender.class);
    private final String url;
    private final String keyword;
    private final String secret;
    private String msgType;
    private final String atMobiles;
    private final String atUserIds;
    private final Boolean atAll;
    private final Boolean enableProxy;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    DingTalkSender(Map<String, String> config) {
        this.url = config.get("WebHook");
        this.keyword = config.get("Keyword");
        this.secret = config.get("Secret");
        this.msgType = config.get("MsgType");
        this.atMobiles = config.get("AtMobiles");
        this.atUserIds = config.get("AtUserIds");
        this.atAll = Boolean.valueOf(config.get("IsAtAll"));
        this.enableProxy = Boolean.valueOf(config.get("IsEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("Port"));
            this.proxy = config.get("Proxy");
            this.user = config.get("User");
            this.password = config.get("Password");
        }
    }

    private static HttpPost constructHttpPost(String url, String msg) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(msg, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        return post;
    }

    private static CloseableHttpClient getProxyClient(String proxy, int port, String user, String password) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(httpProxy), (Credentials)new UsernamePasswordCredentials(user, password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private static CloseableHttpClient getDefaultClient() {
        return HttpClients.createDefault();
    }

    private static RequestConfig getProxyConfig(String proxy, int port) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        return RequestConfig.custom().setProxy(httpProxy).build();
    }

    private AlertResult checkSendDingTalkSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (null == result) {
            alertResult.setMessage("send ding talk msg error");
            logger.info("send ding talk msg error,ding talk server resp is null");
            return alertResult;
        }
        DingTalkSendMsgResponse sendMsgResponse = (DingTalkSendMsgResponse)JSONUtils.parseObject((String)result, DingTalkSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("send ding talk msg fail");
            logger.info("send ding talk msg error,resp error");
            return alertResult;
        }
        if (sendMsgResponse.errcode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("send ding talk msg success");
            return alertResult;
        }
        alertResult.setMessage(String.format("alert send ding talk msg error : %s", sendMsgResponse.getErrmsg()));
        logger.info("alert send ding talk msg error : {}", (Object)sendMsgResponse.getErrmsg());
        return alertResult;
    }

    public AlertResult sendDingTalkMsg(String title, String content) {
        try {
            String resp = this.sendMsg(title, content);
            return this.checkSendDingTalkSendMsgResult(resp);
        }
        catch (Exception e) {
            logger.info("send ding talk alert msg  exception : {}", (Object)e.getMessage());
            AlertResult alertResult = new AlertResult();
            alertResult.setStatus("false");
            alertResult.setMessage("send ding talk alert fail.");
            return alertResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMsg(String title, String content) throws IOException {
        CloseableHttpClient httpClient;
        String msg = this.generateMsgJson(title, content);
        HttpPost httpPost = DingTalkSender.constructHttpPost(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.secret) ? this.url : this.generateSignedUrl(), msg);
        if (Boolean.TRUE.equals(this.enableProxy)) {
            httpClient = DingTalkSender.getProxyClient(this.proxy, this.port, this.user, this.password);
            RequestConfig rcf = DingTalkSender.getProxyConfig(this.proxy, this.port);
            httpPost.setConfig(rcf);
        } else {
            httpClient = DingTalkSender.getDefaultClient();
        }
        try {
            String resp;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            logger.info("Ding Talk send msg :{}, resp: {}", (Object)msg, (Object)resp);
            String string = resp;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    private String generateMsgJson(String title, String content) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.msgType)) {
            this.msgType = "text";
        }
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", this.msgType);
        HashMap<String, Object> text = new HashMap<String, Object>();
        items.put(this.msgType, text);
        if ("markdown".equals(this.msgType)) {
            this.generateMarkdownMsg(title, content, text);
        } else {
            this.generateTextMsg(title, content, text);
        }
        this.setMsgAt(items);
        return JSONUtils.toJsonString(items);
    }

    private void generateTextMsg(String title, String content, Map<String, Object> text) {
        StringBuilder builder = new StringBuilder(title);
        builder.append("\n");
        builder.append(content);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.keyword)) {
            builder.append(" ");
            builder.append(this.keyword);
        }
        byte[] byt = StringUtils.getBytesUtf8((String)builder.toString());
        String txt = StringUtils.newStringUtf8((byte[])byt);
        text.put("content", txt);
    }

    private void generateMarkdownMsg(String title, String content, Map<String, Object> text) {
        StringBuilder builder = new StringBuilder(content);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.keyword)) {
            builder.append(" ");
            builder.append(this.keyword);
        }
        builder.append("\n\n");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.atMobiles)) {
            Arrays.stream(this.atMobiles.split(",")).forEach(value -> {
                builder.append("@");
                builder.append((String)value);
                builder.append(" ");
            });
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.atUserIds)) {
            Arrays.stream(this.atUserIds.split(",")).forEach(value -> {
                builder.append("@");
                builder.append((String)value);
                builder.append(" ");
            });
        }
        byte[] byt = StringUtils.getBytesUtf8((String)builder.toString());
        String txt = StringUtils.newStringUtf8((byte[])byt);
        text.put("title", title);
        text.put("text", txt);
    }

    private void setMsgAt(Map<String, Object> items) {
        HashMap<String, Object> at = new HashMap<String, Object>();
        String[] atMobileArray = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.atMobiles) ? this.atMobiles.split(",") : new String[]{};
        String[] atUserArray = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.atUserIds) ? this.atUserIds.split(",") : new String[]{};
        boolean isAtAll = Objects.isNull(this.atAll) ? false : this.atAll;
        at.put("atMobiles", atMobileArray);
        at.put("atUserIds", atUserArray);
        at.put("isAtAll", isAtAll);
        items.put("at", at);
    }

    private String generateSignedUrl() {
        Long timestamp = System.currentTimeMillis();
        String stringToSign = timestamp + "\n" + this.secret;
        String sign = "";
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.secret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
        }
        catch (Exception e) {
            logger.error("generate sign error, message:{}", (Throwable)e);
        }
        return this.url + "&timestamp=" + timestamp + "&sign=" + sign;
    }

    static final class DingTalkSendMsgResponse {
        private Integer errcode;
        private String errmsg;

        public Integer getErrcode() {
            return this.errcode;
        }

        public void setErrcode(Integer errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DingTalkSendMsgResponse)) {
                return false;
            }
            DingTalkSendMsgResponse other = (DingTalkSendMsgResponse)o;
            Integer this$errcode = this.getErrcode();
            Integer other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !((Object)this$errcode).equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : ((Object)$errcode).hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        public String toString() {
            return "DingTalkSender.DingTalkSendMsgResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }
}

