/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.plugin.alert.http.HttpAlertChannel;
import org.apache.dolphinscheduler.spi.params.base.DataType;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.number.InputNumberParam;

@AutoService(value={AlertChannelFactory.class})
public final class HttpAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Http";
    }

    public List<PluginParams> params() {
        InputParam url = InputParam.newBuilder((String)"url", (String)"$t('url')").setPlaceholder(AlertInputTips.URL.getMsg()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam headerParams = InputParam.newBuilder((String)"headerParams", (String)"$t('headerParams')").setPlaceholder(AlertInputTips.HEADER.getMsg()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam bodyParams = InputParam.newBuilder((String)"bodyParams", (String)"$t('bodyParams')").setPlaceholder(AlertInputTips.JSON_BODY.getMsg()).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam contentField = InputParam.newBuilder((String)"contentField", (String)"$t('contentField')").setPlaceholder(AlertInputTips.FIELD_NAME.getMsg()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam requestType = InputParam.newBuilder((String)"requestType", (String)"$t('requestType')").setPlaceholder(AlertInputTips.HTTP_METHOD.getMsg()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputNumberParam timeout = InputNumberParam.newBuilder((String)"timeout", (String)"$t('timeout')").setValue((Object)120).addValidate(Validate.newBuilder().setType(DataType.NUMBER.getDataType()).setRequired(false).build()).build();
        return Arrays.asList(url, requestType, headerParams, bodyParams, contentField, timeout);
    }

    public AlertChannel create() {
        return new HttpAlertChannel();
    }
}

