/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.api.HttpServiceRetryStrategy;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSender.class);
    private static final String URL_SPLICE_CHAR = "?";
    private static final String REQUEST_TYPE_POST = "POST";
    private static final String REQUEST_TYPE_GET = "GET";
    private static final String DEFAULT_CHARSET = "utf-8";
    private final String headerParams;
    private final String bodyParams;
    private final String contentField;
    private final String requestType;
    private final int timeout;
    private String url;
    private HttpRequestBase httpRequest;

    public HttpSender(Map<String, String> paramsMap) {
        this.url = paramsMap.get("url");
        this.headerParams = paramsMap.get("headerParams");
        this.bodyParams = paramsMap.get("bodyParams");
        this.contentField = paramsMap.get("contentField");
        this.requestType = paramsMap.get("requestType");
        this.timeout = StringUtils.isNotBlank((CharSequence)paramsMap.get("timeout")) ? Integer.parseInt(paramsMap.get("timeout")) : 120;
    }

    public AlertResult send(String msg) {
        AlertResult alertResult = new AlertResult();
        try {
            this.createHttpRequest(msg);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (this.httpRequest == null) {
            alertResult.setStatus("false");
            alertResult.setMessage("Request types are not supported");
            return alertResult;
        }
        try {
            String resp = this.getResponseString(this.httpRequest);
            alertResult.setStatus("true");
            alertResult.setMessage(resp);
        }
        catch (Exception e) {
            log.error("send http alert msg  exception : {}", (Object)e.getMessage());
            alertResult.setStatus("false");
            alertResult.setMessage(String.format("Send http request alert failed: %s", e.getMessage()));
        }
        return alertResult;
    }

    public String getResponseString(HttpRequestBase httpRequest) throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).setConnectionRequestTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)HttpServiceRetryStrategy.retryStrategy).build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
    }

    private void createHttpRequest(String msg) throws MalformedURLException, URISyntaxException {
        if (REQUEST_TYPE_POST.equalsIgnoreCase(this.requestType)) {
            this.httpRequest = new HttpPost(this.url);
            this.setHeader();
            this.setMsgInRequestBody(msg);
        } else if (REQUEST_TYPE_GET.equalsIgnoreCase(this.requestType)) {
            this.setMsgInUrl(msg);
            URL unencodeUrl = new URL(this.url);
            URI uri = new URI(unencodeUrl.getProtocol(), unencodeUrl.getAuthority(), unencodeUrl.getPath(), unencodeUrl.getQuery(), null);
            this.httpRequest = new HttpGet(uri);
            this.setHeader();
        }
    }

    private void setMsgInUrl(String msg) {
        if (StringUtils.isNotBlank((CharSequence)this.contentField)) {
            String type = "&";
            if (!this.url.contains(URL_SPLICE_CHAR)) {
                type = URL_SPLICE_CHAR;
            }
            try {
                this.url = String.format("%s%s%s=%s", this.url, type, this.contentField, URLEncoder.encode(msg, DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setHeader() {
        if (this.httpRequest == null) {
            return;
        }
        HashMap map = (HashMap)JSONUtils.parseObject((String)this.headerParams, HashMap.class);
        for (Map.Entry entry : map.entrySet()) {
            this.httpRequest.setHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private void setMsgInRequestBody(String msg) {
        try {
            ObjectNode objectNode = JSONUtils.createObjectNode();
            if (StringUtils.isNotBlank((CharSequence)this.bodyParams)) {
                objectNode = JSONUtils.parseObject((String)this.bodyParams);
            }
            objectNode.put(this.contentField, msg);
            StringEntity entity = new StringEntity(JSONUtils.toJsonString((Object)objectNode), DEFAULT_CHARSET);
            ((HttpPost)this.httpRequest).setEntity((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("send http alert msg  exception : {}", (Object)e.getMessage());
        }
    }

    public String getRequestUrl() {
        return this.httpRequest.getURI().toString();
    }
}

