/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.pagerduty;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagerDutySender {
    private static final Logger log = LoggerFactory.getLogger(PagerDutySender.class);
    private final String integrationKey;

    public PagerDutySender(Map<String, String> config) {
        this.integrationKey = config.get("IntegrationKey");
        Preconditions.checkArgument((!Objects.isNull(this.integrationKey) ? 1 : 0) != 0, (Object)"PagerDuty integration key can not be null");
    }

    public AlertResult sendPagerDutyAlter(String title, String content) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        alertResult.setMessage("send pager duty alert fail.");
        try {
            this.sendPagerDutyAlterV2(alertResult, title, content);
        }
        catch (Exception e) {
            log.info("send pager duty alert exception : {}", (Object)e.getMessage());
        }
        return alertResult;
    }

    private AlertResult sendPagerDutyAlterV2(AlertResult alertResult, String title, String content) throws IOException {
        String requestBody = this.textToJsonStringV2(title, content);
        return this.send(alertResult, "https://events.pagerduty.com/v2/enqueue", requestBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlertResult send(AlertResult alertResult, String url, String requestBody) throws IOException {
        HttpPost httpPost = PagerDutySender.constructHttpPost(url, requestBody);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            try {
                if (statusCode == 200 || statusCode == 202) {
                    alertResult.setStatus("true");
                    alertResult.setMessage("send pager duty alert success");
                } else {
                    log.info("send pager duty alert fail, statusCode : {}", (Object)statusCode);
                }
            }
            finally {
                response.close();
            }
        }
        return alertResult;
    }

    private String textToJsonStringV2(String title, String content) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("routing_key", this.integrationKey);
        items.put("event_action", "trigger");
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("summary", title);
        payload.put("source", "DolphinScheduler");
        payload.put("severity", "critical");
        payload.put("custom_details", PagerDutySender.formatContent(content));
        items.put("payload", payload);
        return JSONUtils.toJsonString(items);
    }

    private static HttpPost constructHttpPost(String url, String requestBody) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(requestBody, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        return post;
    }

    public static String formatContent(String content) {
        List list = JSONUtils.toList((String)content, Map.class);
        if (list.isEmpty()) {
            return content;
        }
        StringBuilder contents = new StringBuilder(100);
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                contents.append(key + ":" + value);
                contents.append("\n");
            }
        }
        return contents.toString();
    }
}

