/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public final class AlertPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(AlertPluginManager.class);
    private final PluginDao pluginDao;
    private final Map<Integer, AlertChannel> channelKeyedById = new HashMap<Integer, AlertChannel>();
    private final PluginParams warningTypeParams = this.getWarningTypeParams();

    public AlertPluginManager(PluginDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    public PluginParams getWarningTypeParams() {
        return RadioParam.newBuilder((String)"WarningType", (String)"warningType").addParamsOptions(new ParamsOptions(WarningType.SUCCESS.getDescp(), (Object)WarningType.SUCCESS.getDescp(), false)).addParamsOptions(new ParamsOptions(WarningType.FAILURE.getDescp(), (Object)WarningType.FAILURE.getDescp(), false)).addParamsOptions(new ParamsOptions(WarningType.ALL.getDescp(), (Object)WarningType.ALL.getDescp(), false)).setValue((Object)WarningType.ALL.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
    }

    @EventListener
    public void installPlugin(ApplicationReadyEvent readyEvent) {
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(AlertChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            String name = (String)entry.getKey();
            AlertChannelFactory factory = (AlertChannelFactory)entry.getValue();
            logger.info("Registering alert plugin: {} - {}", (Object)name, factory.getClass());
            AlertChannel alertChannel = factory.create();
            logger.info("Registered alert plugin: {} - {}", (Object)name, factory.getClass());
            ArrayList<PluginParams> params = new ArrayList<PluginParams>(factory.params());
            params.add(0, this.warningTypeParams);
            String paramsJson = PluginParamsTransfer.transferParamsToJson(params);
            PluginDefine pluginDefine = new PluginDefine(name, PluginType.ALERT.getDesc(), paramsJson);
            int id = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            this.channelKeyedById.put(id, alertChannel);
        }
    }

    public Optional<AlertChannel> getAlertChannel(int id) {
        return Optional.ofNullable(this.channelKeyedById.get(id));
    }

    public int size() {
        return this.channelKeyedById.size();
    }
}

