/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.alert.AlertSenderService;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendRequestCommand;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AlertRequestProcessor
implements NettyRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AlertRequestProcessor.class);
    private final AlertSenderService alertSenderService;

    public AlertRequestProcessor(AlertSenderService alertSenderService) {
        this.alertSenderService = alertSenderService;
    }

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.ALERT_SEND_REQUEST == command.getType() ? 1 : 0) != 0, (String)"invalid command type: %s", (Object)command.getType());
        AlertSendRequestCommand alertSendRequestCommand = (AlertSendRequestCommand)JsonSerializer.deserialize((byte[])command.getBody(), AlertSendRequestCommand.class);
        logger.info("Received command : {}", (Object)alertSendRequestCommand);
        AlertSendResponseCommand alertSendResponseCommand = this.alertSenderService.syncHandler(alertSendRequestCommand.getGroupId(), alertSendRequestCommand.getTitle(), alertSendRequestCommand.getContent(), alertSendRequestCommand.getWarnType());
        channel.writeAndFlush((Object)alertSendResponseCommand.convert2Command(command.getOpaque()));
    }
}

