/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.io.Closeable;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.alert.AlertConfig;
import org.apache.dolphinscheduler.alert.AlertRequestProcessor;
import org.apache.dolphinscheduler.alert.AlertSenderService;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.EventListener;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
public class AlertServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AlertServer.class);
    private final PluginDao pluginDao;
    private final AlertSenderService alertSenderService;
    private final AlertRequestProcessor alertRequestProcessor;
    private final AlertConfig alertConfig;
    private NettyRemotingServer nettyRemotingServer;

    public AlertServer(PluginDao pluginDao, AlertSenderService alertSenderService, AlertRequestProcessor alertRequestProcessor, AlertConfig alertConfig) {
        this.pluginDao = pluginDao;
        this.alertSenderService = alertSenderService;
        this.alertRequestProcessor = alertRequestProcessor;
        this.alertConfig = alertConfig;
    }

    public static void main(String[] args) {
        Thread.currentThread().setName("Alert-Server");
        new SpringApplicationBuilder(new Class[]{AlertServer.class}).run(args);
    }

    @EventListener
    public void run(ApplicationReadyEvent readyEvent) {
        logger.info("Alert server is staring ...");
        this.checkTable();
        this.startServer();
        this.alertSenderService.start();
        logger.info("Alert server is started ...");
    }

    @Override
    @PreDestroy
    public void close() {
        this.destroy("alert server destroy");
    }

    public void destroy(String cause) {
        try {
            if (!ServerLifeCycleManager.toStopped()) {
                logger.warn("AlterServer is already stopped");
                return;
            }
            logger.info("Alert server is stopping, cause: {}", (Object)cause);
            ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
            this.nettyRemotingServer.close();
            logger.info("Alter server stopped, cause: {}", (Object)cause);
        }
        catch (Exception e) {
            logger.error("Alert server stop failed, cause: {}", (Object)cause, (Object)e);
        }
    }

    private void checkTable() {
        if (!this.pluginDao.checkPluginDefineTableExist()) {
            logger.error("Plugin Define Table t_ds_plugin_define Not Exist . Please Create it First !");
            System.exit(1);
        }
    }

    private void startServer() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.alertConfig.getPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.ALERT_SEND_REQUEST, (NettyRequestProcessor)this.alertRequestProcessor);
        this.nettyRemotingServer.start();
    }
}

