/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.metrics.AlertServerMetrics;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.registry.AlertRegistryClient;
import org.apache.dolphinscheduler.alert.rpc.AlertRpcServer;
import org.apache.dolphinscheduler.alert.service.AlertBootstrapService;
import org.apache.dolphinscheduler.alert.service.ListenerEventPostService;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.EventListener;

@SpringBootApplication
@ComponentScan(value={"org.apache.dolphinscheduler"})
public class AlertServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertServer.class);
    @Autowired
    private AlertBootstrapService alertBootstrapService;
    @Autowired
    private ListenerEventPostService listenerEventPostService;
    @Autowired
    private AlertRpcServer alertRpcServer;
    @Autowired
    private AlertPluginManager alertPluginManager;
    @Autowired
    private AlertRegistryClient alertRegistryClient;

    public static void main(String[] args) {
        AlertServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Alert-Server");
        new SpringApplicationBuilder(new Class[]{AlertServer.class}).run(args);
    }

    @EventListener
    public void run(ApplicationReadyEvent readyEvent) {
        log.info("Alert server is staring ...");
        this.alertPluginManager.start();
        this.alertRegistryClient.start();
        this.alertBootstrapService.start();
        this.listenerEventPostService.start();
        this.alertRpcServer.start();
        log.info("Alert server is started ...");
    }

    @PreDestroy
    public void close() {
        this.destroy("alert server destroy");
    }

    public void destroy(String cause) {
        try {
            if (!ServerLifeCycleManager.toStopped()) {
                log.warn("AlterServer is already stopped");
                return;
            }
            log.info("Alert server is stopping, cause: {}", (Object)cause);
            try (AlertRpcServer closedAlertRpcServer = this.alertRpcServer;
                 AlertBootstrapService closedAlertBootstrapService = this.alertBootstrapService;
                 ListenerEventPostService closedListenerEventPostService = this.listenerEventPostService;){
                AlertRegistryClient closedAlertRegistryClient = this.alertRegistryClient;
                Throwable throwable = null;
                if (closedAlertRegistryClient != null) {
                    if (throwable != null) {
                        try {
                            closedAlertRegistryClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        closedAlertRegistryClient.close();
                    }
                }
            }
            ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
            log.info("Alter server stopped, cause: {}", (Object)cause);
        }
        catch (Exception e) {
            log.error("Alert server stop failed, cause: {}", (Object)cause, (Object)e);
        }
    }
}

