/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
@ConfigurationProperties(value="alert")
public final class AlertConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertConfig.class);
    private int port;
    private int waitTimeout;
    private Duration maxHeartbeatInterval = Duration.ofSeconds(60L);
    private String alertServerAddress;

    public boolean supports(Class<?> clazz) {
        return AlertConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        AlertConfig alertConfig = (AlertConfig)target;
        if (this.maxHeartbeatInterval.getSeconds() <= 0L) {
            errors.rejectValue("max-heartbeat-interval", null, "should be a valid duration");
        }
        if (StringUtils.isEmpty((CharSequence)this.alertServerAddress)) {
            alertConfig.setAlertServerAddress(NetUtils.getAddr((int)alertConfig.getPort()));
        }
        this.printConfig();
    }

    private void printConfig() {
        log.info("Alert config: port -> {}", (Object)this.port);
        log.info("Alert config: alertServerAddress -> {}", (Object)this.alertServerAddress);
        log.info("Alert config: maxHeartbeatInterval -> {}", (Object)this.maxHeartbeatInterval);
    }

    @Generated
    public AlertConfig() {
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Generated
    public Duration getMaxHeartbeatInterval() {
        return this.maxHeartbeatInterval;
    }

    @Generated
    public String getAlertServerAddress() {
        return this.alertServerAddress;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    @Generated
    public void setMaxHeartbeatInterval(Duration maxHeartbeatInterval) {
        this.maxHeartbeatInterval = maxHeartbeatInterval;
    }

    @Generated
    public void setAlertServerAddress(String alertServerAddress) {
        this.alertServerAddress = alertServerAddress;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertConfig)) {
            return false;
        }
        AlertConfig other = (AlertConfig)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getWaitTimeout() != other.getWaitTimeout()) {
            return false;
        }
        Duration this$maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        Duration other$maxHeartbeatInterval = other.getMaxHeartbeatInterval();
        if (this$maxHeartbeatInterval == null ? other$maxHeartbeatInterval != null : !((Object)this$maxHeartbeatInterval).equals(other$maxHeartbeatInterval)) {
            return false;
        }
        String this$alertServerAddress = this.getAlertServerAddress();
        String other$alertServerAddress = other.getAlertServerAddress();
        return !(this$alertServerAddress == null ? other$alertServerAddress != null : !this$alertServerAddress.equals(other$alertServerAddress));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getWaitTimeout();
        Duration $maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        result = result * 59 + ($maxHeartbeatInterval == null ? 43 : ((Object)$maxHeartbeatInterval).hashCode());
        String $alertServerAddress = this.getAlertServerAddress();
        result = result * 59 + ($alertServerAddress == null ? 43 : $alertServerAddress.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlertConfig(port=" + this.getPort() + ", waitTimeout=" + this.getWaitTimeout() + ", maxHeartbeatInterval=" + this.getMaxHeartbeatInterval() + ", alertServerAddress=" + this.getAlertServerAddress() + ")";
    }
}

