/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.alert.config.AlertConfig;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.AlertServerHeartBeat;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlertHeartbeatTask
extends BaseHeartBeatTask<AlertServerHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertHeartbeatTask.class);
    private final AlertConfig alertConfig;
    private final Integer processId;
    private final RegistryClient registryClient;
    private final MetricsProvider metricsProvider;
    private final String heartBeatPath;
    private final long startupTime = System.currentTimeMillis();

    public AlertHeartbeatTask(AlertConfig alertConfig, MetricsProvider metricsProvider, RegistryClient registryClient) {
        super("AlertHeartbeatTask", alertConfig.getMaxHeartbeatInterval().toMillis());
        this.alertConfig = alertConfig;
        this.metricsProvider = metricsProvider;
        this.registryClient = registryClient;
        this.heartBeatPath = RegistryNodeType.ALERT_SERVER.getRegistryPath() + "/" + alertConfig.getAlertServerAddress();
        this.processId = OSUtils.getProcessID();
    }

    public AlertServerHeartBeat getHeartBeat() {
        SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
        return AlertServerHeartBeat.builder().processId(this.processId.intValue()).startupTime(this.startupTime).reportTime(System.currentTimeMillis()).cpuUsage(systemMetrics.getTotalCpuUsedPercentage()).memoryUsage(systemMetrics.getSystemMemoryUsedPercentage()).jvmMemoryUsage(systemMetrics.getJvmMemoryUsedPercentage()).serverStatus(ServerStatus.NORMAL).host(NetUtils.getHost()).port(this.alertConfig.getPort()).build();
    }

    public void writeHeartBeat(AlertServerHeartBeat heartBeat) {
        String heartBeatJson = JSONUtils.toJsonString((Object)heartBeat);
        this.registryClient.persistEphemeral(this.heartBeatPath, heartBeatJson);
        log.debug("Success write master heartBeatInfo into registry, masterRegistryPath: {}, heartBeatInfo: {}", (Object)this.heartBeatPath, (Object)heartBeatJson);
    }
}

