/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.alert.config.AlertConfig;
import org.apache.dolphinscheduler.alert.registry.AlertHeartbeatTask;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertRegistryClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertRegistryClient.class);
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private AlertConfig alertConfig;
    @Autowired
    private MetricsProvider metricsProvider;
    private AlertHeartbeatTask alertHeartbeatTask;

    public void start() {
        log.info("AlertRegistryClient starting...");
        this.registryClient.getLock(RegistryNodeType.ALERT_LOCK.getRegistryPath());
        this.alertHeartbeatTask = new AlertHeartbeatTask(this.alertConfig, this.metricsProvider, this.registryClient);
        this.alertHeartbeatTask.start();
        log.info("AlertRegistryClient started...");
    }

    @Override
    public void close() {
        log.info("AlertRegistryClient closing...");
        this.alertHeartbeatTask.shutdown();
        this.registryClient.releaseLock(RegistryNodeType.ALERT_LOCK.getRegistryPath());
        log.info("AlertRegistryClient closed...");
    }
}

