/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertInfo;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.config.AlertConfig;
import org.apache.dolphinscheduler.alert.metrics.AlertServerMetrics;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.AlertSendStatus;
import org.apache.dolphinscheduler.extract.alert.request.AlertSendResponse;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class AlertBootstrapService
extends BaseDaemonThread
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertBootstrapService.class);
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private AlertPluginManager alertPluginManager;
    @Autowired
    private AlertConfig alertConfig;

    public AlertBootstrapService() {
        super("AlertBootstrapService");
    }

    public void run() {
        log.info("Alert sender thread started");
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                List alerts = this.alertDao.listPendingAlerts();
                if (CollectionUtils.isEmpty((Collection)alerts)) {
                    log.debug("There is not waiting alerts");
                    continue;
                }
                AlertServerMetrics.registerPendingAlertGauge(alerts::size);
                this.send(alerts);
            }
            catch (Exception e) {
                log.error("Alert sender thread meet an exception", (Throwable)e);
            }
            finally {
                ThreadUtils.sleep((long)5000L);
            }
        }
        log.info("Alert sender thread stopped");
    }

    public void send(List<Alert> alerts) {
        for (Alert alert : alerts) {
            int alertId = alert.getId();
            int alertGroupId = Optional.ofNullable(alert.getAlertGroupId()).orElse(0);
            List alertInstanceList = this.alertDao.listInstanceByAlertGroupId(alertGroupId);
            if (CollectionUtils.isEmpty((Collection)alertInstanceList)) {
                log.error("send alert msg fail,no bind plugin instance.");
                ArrayList alertResults = Lists.newArrayList((Object[])new AlertResult[]{new AlertResult("false", "no bind plugin instance")});
                this.alertDao.updateAlert(AlertStatus.EXECUTION_FAILURE, JSONUtils.toJsonString((Object)alertResults), alertId);
                continue;
            }
            AlertData alertData = AlertData.builder().id(alertId).content(alert.getContent()).log(alert.getLog()).title(alert.getTitle()).warnType(alert.getWarningType().getCode()).alertType(alert.getAlertType().getCode()).build();
            int sendSuccessCount = 0;
            ArrayList<AlertSendStatus> alertSendStatuses = new ArrayList<AlertSendStatus>();
            ArrayList<AlertResult> alertResults = new ArrayList<AlertResult>();
            for (AlertPluginInstance instance : alertInstanceList) {
                AlertResult alertResult = this.alertResultHandler(instance, alertData);
                if (alertResult == null) continue;
                AlertStatus sendStatus = Boolean.parseBoolean(alertResult.getStatus()) ? AlertStatus.EXECUTION_SUCCESS : AlertStatus.EXECUTION_FAILURE;
                AlertSendStatus alertSendStatus = AlertSendStatus.builder().alertId(alertId).alertPluginInstanceId(instance.getId().intValue()).sendStatus(sendStatus).log(JSONUtils.toJsonString((Object)alertResult)).createTime(new Date()).build();
                alertSendStatuses.add(alertSendStatus);
                if (AlertStatus.EXECUTION_SUCCESS.equals((Object)sendStatus)) {
                    ++sendSuccessCount;
                    AlertServerMetrics.incAlertSuccessCount();
                } else {
                    AlertServerMetrics.incAlertFailCount();
                }
                alertResults.add(alertResult);
            }
            AlertStatus alertStatus = AlertStatus.EXECUTION_SUCCESS;
            if (sendSuccessCount == 0) {
                alertStatus = AlertStatus.EXECUTION_FAILURE;
            } else if (sendSuccessCount < alertInstanceList.size()) {
                alertStatus = AlertStatus.EXECUTION_PARTIAL_SUCCESS;
            }
            this.alertDao.updateAlert(alertStatus, JSONUtils.toJsonString(alertResults), alertId);
            this.alertDao.insertAlertSendStatus(alertSendStatuses);
        }
    }

    public AlertSendResponse syncHandler(int alertGroupId, String title, String content, int warnType) {
        List alertInstanceList = this.alertDao.listInstanceByAlertGroupId(alertGroupId);
        AlertData alertData = AlertData.builder().content(content).title(title).warnType(warnType).build();
        boolean sendResponseStatus = true;
        ArrayList<AlertSendResponse.AlertSendResponseResult> sendResponseResults = new ArrayList<AlertSendResponse.AlertSendResponseResult>();
        if (CollectionUtils.isEmpty((Collection)alertInstanceList)) {
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult();
            String message = String.format("Alert GroupId %s send error : not found alert instance", alertGroupId);
            alertSendResponseResult.setSuccess(false);
            alertSendResponseResult.setMessage(message);
            sendResponseResults.add(alertSendResponseResult);
            log.error("Alert GroupId {} send error : not found alert instance", (Object)alertGroupId);
            return new AlertSendResponse(false, sendResponseResults);
        }
        for (AlertPluginInstance instance : alertInstanceList) {
            AlertResult alertResult = this.alertResultHandler(instance, alertData);
            if (alertResult == null) continue;
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult(Boolean.parseBoolean(alertResult.getStatus()), alertResult.getMessage());
            sendResponseStatus = sendResponseStatus && alertSendResponseResult.isSuccess();
            sendResponseResults.add(alertSendResponseResult);
        }
        return new AlertSendResponse(sendResponseStatus, sendResponseResults);
    }

    @Nullable
    private AlertResult alertResultHandler(AlertPluginInstance instance, AlertData alertData) {
        WarningType warningType;
        String pluginInstanceName = instance.getInstanceName();
        int pluginDefineId = instance.getPluginDefineId();
        Optional<AlertChannel> alertChannelOptional = this.alertPluginManager.getAlertChannel(instance.getPluginDefineId());
        if (!alertChannelOptional.isPresent()) {
            String message = String.format("Alert Plugin %s send error: the channel doesn't exist, pluginDefineId: %s", pluginInstanceName, pluginDefineId);
            log.error("Alert Plugin {} send error : not found plugin {}", (Object)pluginInstanceName, (Object)pluginDefineId);
            return new AlertResult("false", message);
        }
        AlertChannel alertChannel = alertChannelOptional.get();
        Map paramsMap = JSONUtils.toMap((String)instance.getPluginInstanceParams());
        String instanceWarnType = WarningType.ALL.getDescp();
        if (MapUtils.isNotEmpty((Map)paramsMap)) {
            instanceWarnType = paramsMap.getOrDefault("WarningType", WarningType.ALL.getDescp());
        }
        if ((warningType = WarningType.of((String)instanceWarnType)) == null) {
            String message = String.format("Alert Plugin %s send error : plugin warnType is null", pluginInstanceName);
            log.error("Alert Plugin {} send error : plugin warnType is null", (Object)pluginInstanceName);
            return new AlertResult("false", message);
        }
        boolean sendWarning = false;
        switch (warningType) {
            case ALL: {
                sendWarning = true;
                break;
            }
            case SUCCESS: {
                if (alertData.getWarnType() != WarningType.SUCCESS.getCode()) break;
                sendWarning = true;
                break;
            }
            case FAILURE: {
                if (alertData.getWarnType() != WarningType.FAILURE.getCode()) break;
                sendWarning = true;
                break;
            }
        }
        if (!sendWarning) {
            String message = String.format("Alert Plugin %s send ignore warning type not match: plugin warning type is %s, alert data warning type is %s", pluginInstanceName, warningType.getCode(), alertData.getWarnType());
            log.info("Alert Plugin {} send ignore warning type not match: plugin warning type is {}, alert data warning type is {}", new Object[]{pluginInstanceName, warningType.getCode(), alertData.getWarnType()});
            return new AlertResult("false", message);
        }
        AlertInfo alertInfo = AlertInfo.builder().alertData(alertData).alertParams(paramsMap).alertPluginInstanceId(instance.getId().intValue()).build();
        int waitTimeout = this.alertConfig.getWaitTimeout();
        try {
            AlertResult alertResult;
            if (waitTimeout <= 0) {
                alertResult = alertData.getAlertType() == AlertType.CLOSE_ALERT.getCode() ? alertChannel.closeAlert(alertInfo) : alertChannel.process(alertInfo);
            } else {
                CompletableFuture<AlertResult> future = alertData.getAlertType() == AlertType.CLOSE_ALERT.getCode() ? CompletableFuture.supplyAsync(() -> alertChannel.closeAlert(alertInfo)) : CompletableFuture.supplyAsync(() -> alertChannel.process(alertInfo));
                alertResult = future.get(waitTimeout, TimeUnit.MILLISECONDS);
            }
            if (alertResult == null) {
                throw new RuntimeException("Alert result cannot be null");
            }
            return alertResult;
        }
        catch (InterruptedException e) {
            log.error("send alert error alert data id :{},", (Object)alertData.getId(), (Object)e);
            Thread.currentThread().interrupt();
            return new AlertResult("false", e.getMessage());
        }
        catch (Exception e) {
            log.error("send alert error alert data id :{},", (Object)alertData.getId(), (Object)e);
            return new AlertResult("false", e.getMessage());
        }
    }

    public AlertSendResponse syncTestSend(int pluginDefineId, String pluginInstanceParams) {
        boolean sendResponseStatus = true;
        ArrayList<AlertSendResponse.AlertSendResponseResult> sendResponseResults = new ArrayList<AlertSendResponse.AlertSendResponseResult>();
        Optional<AlertChannel> alertChannelOptional = this.alertPluginManager.getAlertChannel(pluginDefineId);
        if (!alertChannelOptional.isPresent()) {
            String message = String.format("Test send alert error: the channel doesn't exist, pluginDefineId: %s", pluginDefineId);
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult();
            alertSendResponseResult.setSuccess(false);
            alertSendResponseResult.setMessage(message);
            sendResponseResults.add(alertSendResponseResult);
            log.error("Test send alert error : not found plugin {}", (Object)pluginDefineId);
            return new AlertSendResponse(false, sendResponseResults);
        }
        AlertChannel alertChannel = alertChannelOptional.get();
        Map paramsMap = PluginParamsTransfer.getPluginParamsMap((String)pluginInstanceParams);
        AlertData alertData = AlertData.builder().title("DolphinScheduler test alert").content("[{\"message\":\" This is a test alert message form DolphinScheduler\"}]").warnType(WarningType.ALL.getCode()).build();
        AlertInfo alertInfo = AlertInfo.builder().alertData(alertData).alertParams(paramsMap).build();
        try {
            AlertResult alertResult = alertChannel.process(alertInfo);
            if (alertResult != null) {
                AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult(Boolean.parseBoolean(alertResult.getStatus()), alertResult.getMessage());
                sendResponseStatus = alertSendResponseResult.isSuccess();
                sendResponseResults.add(alertSendResponseResult);
            }
        }
        catch (Exception e) {
            log.error("Test send alert error", (Throwable)e);
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult();
            alertSendResponseResult.setSuccess(false);
            alertSendResponseResult.setMessage(e.getMessage());
            sendResponseResults.add(alertSendResponseResult);
            return new AlertSendResponse(false, sendResponseResults);
        }
        return new AlertSendResponse(sendResponseStatus, sendResponseResults);
    }

    @Override
    public void close() {
        log.info("Closed AlertBootstrapService...");
    }
}

