/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.telegram;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.plugin.alert.telegram.TelegramAlertChannel;
import org.apache.dolphinscheduler.spi.params.base.DataType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.input.number.InputNumberParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;
import org.apache.dolphinscheduler.spi.params.select.SelectParam;

@AutoService(value={AlertChannelFactory.class})
public final class TelegramAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Telegram";
    }

    public AlertChannel create() {
        return new TelegramAlertChannel();
    }

    public List<PluginParams> params() {
        InputParam webHookParam = InputParam.newBuilder((String)"webHook", (String)"$t('webHook')").addValidate(Validate.newBuilder().setRequired(true).build()).setPlaceholder(AlertInputTips.WEBHOOK.getMsg()).build();
        InputParam botTokenParam = InputParam.newBuilder((String)"botToken", (String)"botToken").addValidate(Validate.newBuilder().setRequired(true).build()).setPlaceholder(AlertInputTips.BOT_TOKEN.getMsg()).build();
        InputParam chatIdParam = InputParam.newBuilder((String)"chatId", (String)"chatId").addValidate(Validate.newBuilder().setRequired(true).build()).setPlaceholder(AlertInputTips.CHANNEL_ID.getMsg()).build();
        SelectParam parseMode = SelectParam.newBuilder((String)"parseMode", (String)"parseMode").addOptions(new ParamsOptions("Txt", (Object)"Txt", false)).addOptions(new ParamsOptions("Markdown", (Object)"Markdown", false)).addOptions(new ParamsOptions("MarkdownV2", (Object)"MarkdownV2", false)).addOptions(new ParamsOptions("Html", (Object)"Html", false)).setValue((Object)"Txt").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        RadioParam isEnableProxy = RadioParam.newBuilder((String)"IsEnableProxy", (String)"$t('isEnableProxy')").addParamsOptions(new ParamsOptions("YES", (Object)"true", false)).addParamsOptions(new ParamsOptions("NO", (Object)"false", false)).setValue((Object)"false").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam proxyParam = InputParam.newBuilder((String)"Proxy", (String)"$t('proxy')").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputNumberParam portParam = InputNumberParam.newBuilder((String)"Port", (String)"$t('port')").addValidate(Validate.newBuilder().setRequired(false).setType(DataType.NUMBER.getDataType()).build()).build();
        InputParam userParam = InputParam.newBuilder((String)"User", (String)"$t('user')").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam passwordParam = InputParam.newBuilder((String)"Password", (String)"$t('password')").addValidate(Validate.newBuilder().setRequired(false).build()).setPlaceholder("if enable use authentication, you need input password").setType("password").build();
        return Arrays.asList(webHookParam, botTokenParam, chatIdParam, parseMode, isEnableProxy, proxyParam, portParam, userParam, passwordParam);
    }
}

