/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.webexteams;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.alert.api.AlertInputTips;
import org.apache.dolphinscheduler.plugin.alert.webexteams.WebexTeamsAlertChannel;
import org.apache.dolphinscheduler.plugin.alert.webexteams.WebexTeamsDestination;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;

@AutoService(value={AlertChannelFactory.class})
public final class WebexTeamsAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "WebexTeams";
    }

    public List<PluginParams> params() {
        ArrayList<PluginParams> paramsList = new ArrayList<PluginParams>();
        InputParam botAccessToken = InputParam.newBuilder((String)"BotAccessToken", (String)"botAccessToken").setPlaceholder(AlertInputTips.BOT_TOKEN.getMsg()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam roomId = InputParam.newBuilder((String)"RoomId", (String)"roomId").setPlaceholder(AlertInputTips.ROOM_ID.getMsg()).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam toPersonId = InputParam.newBuilder((String)"ToPersonId", (String)"toPersonId").setPlaceholder(AlertInputTips.RECIPIENT_USER_ID.getMsg()).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam toPersonEmail = InputParam.newBuilder((String)"ToPersonEmail", (String)"toPersonEmail").setPlaceholder(AlertInputTips.RECIPIENT_EMAIL.getMsg()).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam atSomeoneInRoom = InputParam.newBuilder((String)"AtSomeoneInRoom", (String)"atSomeoneInRoom").setPlaceholder(AlertInputTips.WEBEX_MENTION_USERS.getMsg()).addValidate(Validate.newBuilder().setRequired(false).build()).build();
        RadioParam destination = RadioParam.newBuilder((String)"Destination", (String)"destination").addParamsOptions(new ParamsOptions(WebexTeamsDestination.ROOM_ID.getDescp(), (Object)WebexTeamsDestination.ROOM_ID.getDescp(), false)).addParamsOptions(new ParamsOptions(WebexTeamsDestination.PERSON_EMAIL.getDescp(), (Object)WebexTeamsDestination.PERSON_EMAIL.getDescp(), false)).addParamsOptions(new ParamsOptions(WebexTeamsDestination.PERSON_ID.getDescp(), (Object)WebexTeamsDestination.PERSON_ID.getDescp(), false)).setValue((Object)WebexTeamsDestination.ROOM_ID.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        paramsList.add((PluginParams)botAccessToken);
        paramsList.add((PluginParams)roomId);
        paramsList.add((PluginParams)toPersonId);
        paramsList.add((PluginParams)toPersonEmail);
        paramsList.add((PluginParams)atSomeoneInRoom);
        paramsList.add((PluginParams)destination);
        return paramsList;
    }

    public AlertChannel create() {
        return new WebexTeamsAlertChannel();
    }
}

