/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.api.audit.AuditMessage;
import org.apache.dolphinscheduler.api.audit.AuditSubscriber;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditPublishService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditPublishService.class);
    private final BlockingQueue<AuditMessage> auditMessageQueue = new LinkedBlockingQueue<AuditMessage>();
    @Autowired
    private List<AuditSubscriber> subscribers;
    @Autowired
    private ApiConfig apiConfig;

    @PostConstruct
    private void init() {
        if (this.apiConfig.isAuditEnable()) {
            Thread thread = new Thread(this::doPublish);
            thread.setDaemon(true);
            thread.setName("Audit-Log-Consume-Thread");
            thread.start();
        }
    }

    public void publish(AuditMessage message) {
        if (this.apiConfig.isAuditEnable() && !this.auditMessageQueue.offer(message)) {
            log.error("Publish audit message failed, message:{}", (Object)message);
        }
    }

    private void doPublish() {
        AuditMessage message = null;
        try {
            block4: while (true) {
                message = this.auditMessageQueue.take();
                Iterator<AuditSubscriber> iterator = this.subscribers.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    AuditSubscriber subscriber = iterator.next();
                    try {
                        subscriber.execute(message);
                    }
                    catch (Exception e) {
                        log.error("Consume audit message failed, message:{}", (Object)message, (Object)e);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            log.error("Consume audit message failed, message:{}", (Object)message, (Object)e);
            Thread.currentThread().interrupt();
            return;
        }
    }
}

