/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerServerModel;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="MONITOR_TAG")
@RestController
@RequestMapping(value={"/monitor"})
public class MonitorController
extends BaseController {
    @Autowired
    private MonitorService monitorService;

    @Operation(summary="listMaster", description="MASTER_LIST_NOTES")
    @GetMapping(value={"/masters"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_MASTERS_ERROR)
    public Result<List<Server>> listMaster(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<Server> servers = this.monitorService.queryMaster(loginUser);
        return Result.success(servers);
    }

    @Operation(summary="listWorker", description="WORKER_LIST_NOTES")
    @GetMapping(value={"/workers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_WORKERS_ERROR)
    public Result<List<WorkerServerModel>> listWorker(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<WorkerServerModel> workerServerModels = this.monitorService.queryWorker(loginUser);
        return Result.success(workerServerModels);
    }

    @Operation(summary="queryDatabaseState", description="QUERY_DATABASE_STATE_NOTES")
    @GetMapping(value={"/databases"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATABASE_STATE_ERROR)
    public Result<List<DatabaseMetrics>> queryDatabaseState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<DatabaseMetrics> databaseMetrics = this.monitorService.queryDatabaseState(loginUser);
        return Result.success(databaseMetrics);
    }
}

