/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROCESS_TASK_RELATION_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/process-task-relation"})
public class ProcessTaskRelationController
extends BaseController {
    @Autowired
    private ProcessTaskRelationService processTaskRelationService;

    @Operation(summary="save", description="CREATE_PROCESS_TASK_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="preTaskCode", description="PRE_TASK_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="postTaskCode", description="POST_TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_TASK_RELATION_ERROR)
    public Result createProcessTaskRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="processDefinitionCode", required=true) long processDefinitionCode, @RequestParam(name="preTaskCode", required=true) long preTaskCode, @RequestParam(name="postTaskCode", required=true) long postTaskCode) {
        Map<String, Object> result = new HashMap<String, Object>();
        if (postTaskCode == 0L) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "postTaskCode");
        } else if (processDefinitionCode == 0L) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "processDefinitionCode");
        } else {
            result = this.processTaskRelationService.createProcessTaskRelation(loginUser, projectCode, processDefinitionCode, preTaskCode, postTaskCode);
        }
        return this.returnDataList(result);
    }

    @Operation(summary="deleteRelation", description="DELETE_PROCESS_TASK_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @DeleteMapping(value={"/{taskCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    public Result deleteTaskProcessRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="processDefinitionCode", required=true) long processDefinitionCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteTaskProcessRelation(loginUser, projectCode, processDefinitionCode, taskCode));
    }

    @Operation(summary="deleteUpstreamRelation", description="DELETE_UPSTREAM_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="preTaskCodes", description="PRE_TASK_CODES", required=true, schema=@Schema(implementation=String.class, example="1,2")), @Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @DeleteMapping(value={"/{taskCode}/upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    public Result deleteUpstreamRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="preTaskCodes", required=true) String preTaskCodes, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteUpstreamRelation(loginUser, projectCode, preTaskCodes, taskCode));
    }

    @Operation(summary="deleteDownstreamRelation", description="DELETE_DOWNSTREAM_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="postTaskCodes", description="POST_TASK_CODES", required=true, schema=@Schema(implementation=String.class, example="1,2")), @Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @DeleteMapping(value={"/{taskCode}/downstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    public Result deleteDownstreamRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(name="postTaskCodes", required=true) String postTaskCodes, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteDownstreamRelation(loginUser, projectCode, postTaskCodes, taskCode));
    }

    @Operation(summary="queryUpstreamRelation", description="QUERY_UPSTREAM_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @GetMapping(value={"/{taskCode}/upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_PROCESS_RELATION_ERROR)
    public Result queryUpstreamRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.queryUpstreamRelation(loginUser, projectCode, taskCode));
    }

    @Operation(summary="queryDownstreamRelation", description="QUERY_DOWNSTREAM_RELATION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskCode", description="TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @GetMapping(value={"/{taskCode}/downstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_PROCESS_RELATION_ERROR)
    public Result queryDownstreamRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="taskCode") long taskCode) {
        return this.returnDataList(this.processTaskRelationService.queryDownstreamRelation(loginUser, projectCode, taskCode));
    }

    @Operation(summary="deleteEdge", description="DELETE_EDGE_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="preTaskCode", description="PRE_TASK_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="postTaskCode", description="POST_TASK_CODE", required=true, schema=@Schema(implementation=long.class))})
    @DeleteMapping(value={"/{processDefinitionCode}/{preTaskCode}/{postTaskCode}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_EDGE_ERROR)
    public Result deleteEdge(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable long processDefinitionCode, @PathVariable long preTaskCode, @PathVariable long postTaskCode) {
        return this.returnDataList(this.processTaskRelationService.deleteEdge(loginUser, projectCode, processDefinitionCode, preTaskCode, postTaskCode));
    }
}

