/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROJECT_TAG")
@RestController
@RequestMapping(value={"projects"})
public class ProjectController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;

    @Operation(summary="create", description="CREATE_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="projectName", description="PROJECT_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="PROJECT_DESC", schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROJECT_ERROR)
    public Result createProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description) {
        return this.projectService.createProject(loginUser, projectName, description);
    }

    @Operation(summary="update", description="UPDATE_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="123456")), @Parameter(name="projectName", description="PROJECT_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="PROJECT_DESC", schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROJECT_ERROR)
    public Result updateProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestParam(value="projectName") String projectName, @RequestParam(value="description", required=false) String description) {
        return this.projectService.update(loginUser, code, projectName, description);
    }

    @Operation(summary="queryProjectByCode", description="QUERY_PROJECT_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="123456"))})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROJECT_DETAILS_BY_CODE_ERROR)
    public Result queryProjectByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") long code) {
        return this.projectService.queryByCode(loginUser, code);
    }

    @Operation(summary="queryProjectListPaging", description="QUERY_PROJECT_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    public Result queryProjectListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.projectService.queryProjectListPaging(loginUser, pageSize, pageNo, searchVal);
    }

    @Operation(summary="queryProjectWithAuthorizedLevelListPaging", description="QUERY_PROJECT_WITH_AUTH_LEVEL_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/project-with-authorized-level-list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    public Result queryProjectWithAuthorizedLevelListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNo") Integer pageNo) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.projectService.queryProjectWithAuthorizedLevelListPaging(userId, loginUser, pageSize, pageNo, searchVal);
    }

    @Operation(summary="delete", description="DELETE_PROJECT_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="code", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="123456"))})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROJECT_ERROR)
    public Result deleteProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        return this.projectService.deleteProject(loginUser, code);
    }

    @Operation(summary="queryUnauthorizedProject", description="QUERY_UNAUTHORIZED_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/unauth-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UNAUTHORIZED_PROJECT_ERROR)
    public Result queryUnauthorizedProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        return this.projectService.queryUnauthorizedProject(loginUser, userId);
    }

    @Operation(summary="queryAuthorizedProject", description="QUERY_AUTHORIZED_PROJECT_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/authed-project"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_PROJECT)
    public Result queryAuthorizedProject(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        return this.projectService.queryAuthorizedProject(loginUser, userId);
    }

    @Operation(summary="queryProjectWithAuthorizedLevel", description="QUERY_PROJECT_AUTHORIZED_LEVEL")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/project-with-authorized-level"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_PROJECT)
    public Result queryProjectWithAuthorizedLevel(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        return this.projectService.queryProjectWithAuthorizedLevel(loginUser, userId);
    }

    @Operation(summary="queryAuthorizedUser", description="QUERY_AUTHORIZED_USER_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="100"))})
    @GetMapping(value={"/authed-user"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_USER)
    public Result queryAuthorizedUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="projectCode") Long projectCode) {
        return this.projectService.queryAuthorizedUser(loginUser, projectCode);
    }

    @Operation(summary="queryProjectCreatedAndAuthorizedByUser", description="QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_NOTES")
    @GetMapping(value={"/created-and-authed"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_AUTHORIZED_AND_USER_CREATED_PROJECT_ERROR)
    public Result queryProjectCreatedAndAuthorizedByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        return this.projectService.queryProjectCreatedAndAuthorizedByUser(loginUser);
    }

    @Operation(summary="queryAllProjectList", description="QUERY_ALL_PROJECT_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    public Result queryAllProjectList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        return this.projectService.queryAllProjectList(loginUser);
    }

    @Operation(summary="queryAllProjectListForDependent", description="QUERY_ALL_PROJECT_LIST_FOR_DEPENDENT_NOTES")
    @GetMapping(value={"/list-dependent"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    public Result queryAllProjectListForDependent(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        return this.projectService.queryAllProjectListForDependent();
    }
}

