/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.resources.DeleteDataTransferResponse;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="RESOURCES_TAG")
@RestController
@RequestMapping(value={"resources"})
public class ResourcesController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesController.class);
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private UdfFuncService udfFuncService;

    @Operation(summary="createDirectory", description="CREATE_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="name", description="RESOURCE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="pid", description="RESOURCE_PID", required=true, schema=@Schema(implementation=int.class, example="10")), @Parameter(name="currentDir", description="RESOURCE_CURRENT_DIR", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/directory"})
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    public Result<Object> createDirectory(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        return this.resourceService.createDirectory(loginUser, alias, type, pid, currentDir);
    }

    @Operation(summary="createResource", description="CREATE_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="name", description="RESOURCE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="file", description="RESOURCE_FILE", required=true, schema=@Schema(implementation=MultipartFile.class)), @Parameter(name="currentDir", description="RESOURCE_CURRENT_DIR", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    public Result<Object> createResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="file") MultipartFile file, @RequestParam(value="currentDir") String currentDir) {
        return this.resourceService.createResource(loginUser, alias, type, file, currentDir);
    }

    @Operation(summary="updateResource", description="UPDATE_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="fullName", description="RESOURCE_FULLNAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="name", description="RESOURCE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="file", description="RESOURCE_FILE", required=true, schema=@Schema(implementation=MultipartFile.class))})
    @PutMapping
    @ApiException(value=Status.UPDATE_RESOURCE_ERROR)
    public Result<Object> updateResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode", required=false) String tenantCode, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="file", required=false) MultipartFile file) {
        return this.resourceService.updateResource(loginUser, fullName, tenantCode, alias, type, file);
    }

    @Operation(summary="queryResourceList", description="QUERY_RESOURCE_LIST_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fullName", description="RESOURCE_FULLNAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    public Result<Object> queryResourceList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fullName") String fullName) {
        Map<String, Object> result = this.resourceService.queryResourceList(loginUser, type, fullName);
        return this.returnDataList(result);
    }

    @Operation(summary="queryResourceListPaging", description="QUERY_RESOURCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fullName", description="RESOURCE_FULLNAME", required=true, schema=@Schema(implementation=String.class, example="bucket_name/tenant_name/type/ds")), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_PAGING)
    public Result<PageInfo<StorageEntity>> queryResourceListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="type") ResourceType type, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.resourceService.queryResourceListPaging(loginUser, fullName, tenantCode, type, searchVal, pageNo, pageSize);
    }

    @Operation(summary="deleteResource", description="DELETE_RESOURCE_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="fullName", description="RESOURCE_FULLNAME", required=true, schema=@Schema(implementation=String.class, example="test/"))})
    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_RESOURCE_ERROR)
    public Result<Object> deleteResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode", required=false) String tenantCode) throws Exception {
        return this.resourceService.delete(loginUser, fullName, tenantCode);
    }

    @Operation(summary="deleteDataTransferData", description="Delete the N days ago data of DATA_TRANSFER ")
    @Parameters(value={@Parameter(name="days", description="N days ago", required=true, schema=@Schema(implementation=Integer.class))})
    @DeleteMapping(value={"/data-transfer"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_RESOURCE_ERROR)
    public DeleteDataTransferResponse deleteDataTransferData(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="days") Integer days) {
        return this.resourceService.deleteDataTransferData(loginUser, days);
    }

    @Operation(summary="verifyResourceName", description="VERIFY_RESOURCE_NAME_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fullName", description="RESOURCE_FULL_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR)
    public Result<Object> verifyResourceName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="type") ResourceType type) {
        return this.resourceService.verifyResourceName(fullName, type, loginUser);
    }

    @Operation(summary="queryResourceByProgramType", description="QUERY_RESOURCE_LIST_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class))})
    @GetMapping(value={"/query-by-type"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    public Result<Object> queryResourceJarList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="programType", required=false) ProgramType programType) {
        return this.resourceService.queryResourceByProgramType(loginUser, type, programType);
    }

    @Operation(summary="queryResourceByFileName", description="QUERY_BY_RESOURCE_FILE_NAME")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fileName", description="RESOURCE_FILE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/query-file-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RESOURCE_NOT_EXIST)
    public Result<Object> queryResourceByFileName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="tenantCode", required=false) String tenantCode, @RequestParam(value="type") ResourceType type) {
        return this.resourceService.queryResourceByFileName(loginUser, fileName, type, tenantCode);
    }

    @Operation(summary="viewResource", description="VIEW_RESOURCE_BY_ID_NOTES")
    @Parameters(value={@Parameter(name="fullName", description="RESOURCE_FULL_NAME", required=true, schema=@Schema(implementation=String.class, example="tenant/1.png")), @Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="skipLineNum", description="SKIP_LINE_NUM", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="limit", description="LIMIT", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/view"})
    @ApiException(value=Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR)
    public Result viewResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="skipLineNum") int skipLineNum, @RequestParam(value="limit") int limit, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode") String tenantCode) {
        return this.resourceService.readResource(loginUser, fullName, tenantCode, skipLineNum, limit);
    }

    @Operation(summary="onlineCreateResource", description="ONLINE_CREATE_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fileName", description="RESOURCE_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="suffix", description="SUFFIX", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="description", description="RESOURCE_DESC", schema=@Schema(implementation=String.class)), @Parameter(name="content", description="CONTENT", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="currentDir", description="RESOURCE_CURRENTDIR", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/online-create"})
    @ApiException(value=Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR)
    public Result onlineCreateResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fileName") String fileName, @RequestParam(value="suffix") String fileSuffix, @RequestParam(value="content") String content, @RequestParam(value="currentDir") String currentDir) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.error("resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.onlineCreateResource(loginUser, type, fileName, fileSuffix, content, currentDir);
    }

    @Operation(summary="updateResourceContent", description="UPDATE_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="content", description="CONTENT", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="fullName", description="FULL_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/update-content"})
    @ApiException(value=Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR)
    public Result updateResourceContent(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="content") String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.error("The resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.updateResourceContent(loginUser, fullName, tenantCode, content);
    }

    @Operation(summary="downloadResource", description="DOWNLOAD_RESOURCE_NOTES")
    @Parameters(value={@Parameter(name="fullName", description="RESOURCE_FULLNAME", required=true, schema=@Schema(implementation=String.class, example="test/"))})
    @GetMapping(value={"/download"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_RESOURCE_FILE_ERROR)
    public ResponseEntity downloadResource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName) throws Exception {
        Resource file = this.resourceService.downloadResource(loginUser, fullName);
        if (file == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.RESOURCE_NOT_EXIST.getMsg());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    @Operation(summary="createUdfFunc", description="CREATE_UDF_FUNCTION_NOTES")
    @Parameters(value={@Parameter(name="type", description="UDF_TYPE", required=true, schema=@Schema(implementation=UdfType.class)), @Parameter(name="funcName", description="FUNC_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="className", description="CLASS_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="argTypes", description="ARG_TYPES", schema=@Schema(implementation=String.class)), @Parameter(name="database", description="DATABASE_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="UDF_DESC", schema=@Schema(implementation=String.class)), @Parameter(name="resourceId", description="RESOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @PostMapping(value={"/udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_UDF_FUNCTION_ERROR)
    public Result createUdfFunc(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="fullName") String fullName, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description) {
        return this.udfFuncService.createUdfFunction(loginUser, funcName, className, fullName, argTypes, database, description, type);
    }

    @Operation(summary="viewUIUdfFunction", description="VIEW_UDF_FUNCTION_NOTES")
    @Parameters(value={@Parameter(name="id", description="RESOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}/udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VIEW_UDF_FUNCTION_ERROR)
    public Result viewUIUdfFunction(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        return this.udfFuncService.queryUdfFuncDetail(loginUser, id);
    }

    @Operation(summary="updateUdfFunc", description="UPDATE_UDF_FUNCTION_NOTES")
    @Parameters(value={@Parameter(name="id", description="UDF_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="type", description="UDF_TYPE", required=true, schema=@Schema(implementation=UdfType.class)), @Parameter(name="funcName", description="FUNC_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="className", description="CLASS_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="argTypes", description="ARG_TYPES", schema=@Schema(implementation=String.class)), @Parameter(name="database", description="DATABASE_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="UDF_DESC", schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/udf-func/{id}"})
    @ApiException(value=Status.UPDATE_UDF_FUNCTION_ERROR)
    public Result updateUdfFunc(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int udfFuncId, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @RequestParam(value="fullName") String fullName) {
        return this.udfFuncService.updateUdfFunc(loginUser, udfFuncId, funcName, className, argTypes, database, description, type, fullName);
    }

    @Operation(summary="queryUdfFuncListPaging", description="QUERY_UDF_FUNCTION_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping(value={"/udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR)
    public Result<Object> queryUdfFuncListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        return this.udfFuncService.queryUdfFuncListPaging(loginUser, searchVal, pageNo, pageSize);
    }

    @Operation(summary="queryUdfFuncList", description="QUERY_UDF_FUNC_LIST_NOTES")
    @Parameters(value={@Parameter(name="type", description="UDF_TYPE", required=true, schema=@Schema(implementation=UdfType.class))})
    @GetMapping(value={"/udf-func/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_BY_TYPE_ERROR)
    public Result<Object> queryUdfFuncList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type) {
        return this.udfFuncService.queryUdfFuncList(loginUser, type.ordinal());
    }

    @Operation(summary="verifyUdfFuncName", description="VERIFY_UDF_FUNCTION_NAME_NOTES")
    @Parameters(value={@Parameter(name="name", description="FUNC_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/udf-func/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_UDF_FUNCTION_NAME_ERROR)
    public Result verifyUdfFuncName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        return this.udfFuncService.verifyUdfFuncByName(loginUser, name);
    }

    @Operation(summary="deleteUdfFunc", description="DELETE_UDF_FUNCTION_NOTES")
    @Parameters(value={@Parameter(name="id", description="UDF_FUNC_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/udf-func/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_UDF_FUNCTION_ERROR)
    public Result deleteUdfFunc(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int udfFuncId) {
        return this.udfFuncService.delete(loginUser, udfFuncId);
    }

    @Operation(summary="unauthUDFFunc", description="UNAUTHORIZED_UDF_FUNC_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/unauth-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UNAUTHORIZED_UDF_FUNCTION_ERROR)
    public Result unauthUDFFunc(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.unauthorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }

    @Operation(summary="authUDFFunc", description="AUTHORIZED_UDF_FUNC_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/authed-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZED_UDF_FUNCTION_ERROR)
    public Result authorizedUDFFunction(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.authorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }

    @Operation(summary="queryResourceByFullName", description="QUERY_BY_RESOURCE_FULL_NAME")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class)), @Parameter(name="fullName", description="RESOURCE_FULL_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/query-full-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RESOURCE_NOT_EXIST)
    public Result queryResourceByFullName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fullName") String fullName, @RequestParam(value="tenantCode") String tenantCode) throws IOException {
        return this.resourceService.queryResourceByFullName(loginUser, fullName, tenantCode, type);
    }

    @Operation(summary="queryResourceBaseDir", description="QUERY_RESOURCE_BASE_DIR")
    @Parameters(value={@Parameter(name="type", description="RESOURCE_TYPE", required=true, schema=@Schema(implementation=ResourceType.class))})
    @GetMapping(value={"/base-dir"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RESOURCE_NOT_EXIST)
    public Result<Object> queryResourceBaseDir(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type) {
        return this.resourceService.queryResourceBaseDir(loginUser, type);
    }
}

