/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TASK_DEFINITION_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/task-definition"})
public class TaskDefinitionController
extends BaseController {
    @Autowired
    private TaskDefinitionService taskDefinitionService;

    @Operation(summary="save", description="CREATE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskDefinitionJson", description="TASK_DEFINITION_JSON", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    public Result createTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson) {
        Map<String, Object> result = this.taskDefinitionService.createTaskDefinition(loginUser, projectCode, taskDefinitionJson);
        return this.returnDataList(result);
    }

    @Operation(summary="saveSingle", description="CREATE_SINGLE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="processDefinitionCode", description="PROCESS_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="taskDefinitionJsonObj", description="TASK_DEFINITION_JSON", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="upstreamCodes", description="UPSTREAM_CODES", required=false, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/save-single"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    public Result createTaskBindsWorkFlow(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode", required=true) long processDefinitionCode, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj, @RequestParam(value="upstreamCodes", required=false) String upstreamCodes) {
        Map<String, Object> result = this.taskDefinitionService.createTaskBindsWorkFlow(loginUser, projectCode, processDefinitionCode, taskDefinitionJsonObj, StringUtils.defaultString((String)upstreamCodes));
        return this.returnDataList(result);
    }

    @Operation(summary="update", description="UPDATE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="taskDefinitionJsonObj", description="TASK_DEFINITION_JSON", required=true, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    public Result updateTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj) {
        Map<String, Object> result = this.taskDefinitionService.updateTaskDefinition(loginUser, projectCode, code, taskDefinitionJsonObj);
        return this.returnDataList(result);
    }

    @Operation(summary="updateWithUpstream", description="UPDATE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="taskDefinitionJsonObj", description="TASK_DEFINITION_JSON", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="upstreamCodes", description="UPSTREAM_CODES", required=false, schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{code}/with-upstream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    public Result updateTaskWithUpstream(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj, @RequestParam(value="upstreamCodes", required=false) String upstreamCodes) {
        Map<String, Object> result = this.taskDefinitionService.updateTaskWithUpstream(loginUser, projectCode, code, taskDefinitionJsonObj, upstreamCodes);
        return this.returnDataList(result);
    }

    @Operation(summary="queryVersions", description="QUERY_TASK_DEFINITION_VERSIONS_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping(value={"/{code}/versions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_VERSIONS_ERROR)
    public Result queryTaskDefinitionVersions(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        this.checkPageParams(pageNo, pageSize);
        return this.taskDefinitionService.queryTaskDefinitionVersions(loginUser, projectCode, code, pageNo, pageSize);
    }

    @Operation(summary="switchVersion", description="SWITCH_TASK_DEFINITION_VERSION_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="version", description="VERSION", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SWITCH_TASK_DEFINITION_VERSION_ERROR)
    public Result switchTaskDefinitionVersion(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.switchVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteVersion", description="DELETE_TASK_DEFINITION_VERSION_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1")), @Parameter(name="version", description="VERSION", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINITION_VERSION_ERROR)
    public Result deleteTaskDefinitionVersion(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.deleteByCodeAndVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @Operation(summary="deleteTaskDefinition", description="DELETE_TASK_DEFINITION_BY_CODE_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1"))})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINE_BY_CODE_ERROR)
    public Result deleteTaskDefinitionByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        this.taskDefinitionService.deleteTaskDefinitionByCode(loginUser, code);
        return new Result(Status.SUCCESS);
    }

    @Operation(summary="queryTaskDefinitionByCode", description="QUERY_TASK_DEFINITION_DETAIL_NOTES")
    @Parameters(value={@Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="1"))})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_TASK_DEFINITION_ERROR)
    public Result queryTaskDefinitionDetail(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.taskDefinitionService.queryTaskDefinitionDetail(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @Operation(summary="queryTaskDefinitionListPaging", description="QUERY_TASK_DEFINITION_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", required=false, schema=@Schema(implementation=long.class)), @Parameter(name="searchWorkflowName", description="SEARCH_WORKFLOW_NAME", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="searchTaskName", description="SEARCH_TASK_NAME", required=false, schema=@Schema(implementation=String.class)), @Parameter(name="taskType", description="TASK_TYPE", required=false, schema=@Schema(implementation=String.class, example="SHELL")), @Parameter(name="taskExecuteType", description="TASK_EXECUTE_TYPE", required=false, schema=@Schema(implementation=TaskExecuteType.class, example="STREAM")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="10"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_LIST_PAGING_ERROR)
    public Result queryTaskDefinitionListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="searchTaskName", required=false) String searchTaskName, @RequestParam(value="taskType", required=false) String taskType, @RequestParam(value="taskExecuteType", required=false, defaultValue="BATCH") TaskExecuteType taskExecuteType, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchTaskName = ParameterUtils.handleEscapes((String)searchTaskName);
        return this.taskDefinitionService.queryTaskDefinitionListPaging(loginUser, projectCode, searchTaskName, taskType, taskExecuteType, pageNo, pageSize);
    }

    @Operation(summary="genTaskCodeList", description="GEN_TASK_CODE_LIST_NOTES")
    @Parameters(value={@Parameter(name="genNum", description="GEN_NUM", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/gen-task-codes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    public Result genTaskCodeList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="genNum") Integer genNum) {
        Map<String, Object> result = this.taskDefinitionService.genTaskCodeList(genNum);
        return this.returnDataList(result);
    }

    @Operation(summary="releaseTaskDefinition", description="RELEASE_TASK_DEFINITION_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROCESS_DEFINITION_NAME", required=true, schema=@Schema(implementation=long.class)), @Parameter(name="code", description="TASK_DEFINITION_CODE", required=true, schema=@Schema(implementation=long.class, example="123456789")), @Parameter(name="releaseState", description="RELEASE_PROCESS_DEFINITION_NOTES", required=true, schema=@Schema(implementation=ReleaseState.class))})
    @PostMapping(value={"/{code}/release"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RELEASE_TASK_DEFINITION_ERROR)
    public Result releaseTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code", required=true) long code, @RequestParam(value="releaseState", required=true, defaultValue="OFFLINE") ReleaseState releaseState) {
        Map<String, Object> result = this.taskDefinitionService.releaseTaskDefinition(loginUser, projectCode, code, releaseState);
        return this.returnDataList(result);
    }
}

