/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationCreateRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationDeleteRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationUpdateUpstreamRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROCESS_TASK_RELATION_TAG")
@RestController
@RequestMapping(value={"v2/relations"})
public class ProcessTaskRelationV2Controller
extends BaseController {
    @Autowired
    private ProcessTaskRelationService processTaskRelationService;

    @Operation(summary="create", description="CREATE_PROCESS_TASK_RELATION_NOTES")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_TASK_RELATION_ERROR)
    public Result<ProcessTaskRelation> createTaskRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody TaskRelationCreateRequest TaskRelationCreateRequest2) {
        ProcessTaskRelation processTaskRelation = this.processTaskRelationService.createProcessTaskRelationV2(loginUser, TaskRelationCreateRequest2);
        return Result.success(processTaskRelation);
    }

    @Operation(summary="delete", description="DELETE_PROCESS_TASK_RELATION_NOTES")
    @Parameters(value={@Parameter(name="code-pair", description="TASK_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="123456,78901", required=true))})
    @DeleteMapping(value={"/{code-pair}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_PROCESS_RELATION_ERROR)
    public Result deleteTaskRelation(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code-pair") String codePair) {
        TaskRelationDeleteRequest taskRelationDeleteRequest = new TaskRelationDeleteRequest(codePair);
        this.processTaskRelationService.deleteTaskProcessRelationV2(loginUser, taskRelationDeleteRequest.getUpstreamCode(), taskRelationDeleteRequest.getDownstreamCode());
        return Result.success();
    }

    @Operation(summary="update", description="UPDATE_PROCESS_TASK_RELATION_NOTES")
    @Parameters(value={@Parameter(name="code", description="DOWNSTREAM_TASK_DEFINITION_CODE", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_UPSTREAM_TASK_PROCESS_RELATION_ERROR)
    public Result<List<ProcessTaskRelation>> updateUpstreamTaskDefinition(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestBody TaskRelationUpdateUpstreamRequest taskRelationUpdateUpstreamRequest) {
        List<ProcessTaskRelation> processTaskRelations = this.processTaskRelationService.updateUpstreamTaskDefinitionWithSyncDag(loginUser, code, Boolean.TRUE, taskRelationUpdateUpstreamRequest);
        return Result.success(processTaskRelations);
    }
}

