/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.workflowInstance.WorkflowInstanceQueryRequest;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="WORKFLOW_INSTANCE_TAG_V2")
@RestController
@RequestMapping(value={"/v2/workflow-instances"})
public class WorkflowInstanceV2Controller
extends BaseController {
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ExecutorService execService;

    @Operation(summary="queryWorkflowInstanceListPaging", description="QUERY_PROCESS_INSTANCE_LIST_NOTES")
    @GetMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_LIST_PAGING_ERROR)
    public Result queryWorkflowInstanceListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody WorkflowInstanceQueryRequest workflowInstanceQueryRequest) {
        this.checkPageParams(workflowInstanceQueryRequest.getPageNo(), workflowInstanceQueryRequest.getPageSize());
        return this.processInstanceService.queryProcessInstanceList(loginUser, workflowInstanceQueryRequest);
    }

    @Operation(summary="queryWorkflowInstanceById", description="QUERY_WORKFLOW_INSTANCE_BY_ID")
    @Parameters(value={@Parameter(name="workflowInstanceId", description="WORKFLOW_INSTANCE_ID", schema=@Schema(implementation=Integer.class, example="123456", required=true))})
    @GetMapping(value={"/{workflowInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_INSTANCE_BY_ID_ERROR)
    public Result queryWorkflowInstanceById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="workflowInstanceId") Integer workflowInstanceId) {
        Map<String, Object> result = this.processInstanceService.queryProcessInstanceById(loginUser, workflowInstanceId);
        return this.returnDataList(result);
    }

    @Operation(summary="delete", description="DELETE_WORKFLOWS_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="workflowInstanceId", description="WORKFLOW_INSTANCE_ID", schema=@Schema(implementation=Integer.class, example="123456", required=true))})
    @DeleteMapping(value={"/{workflowInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR)
    public Result<Void> deleteWorkflowInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="workflowInstanceId") Integer workflowInstanceId) {
        this.processInstanceService.deleteProcessInstanceById(loginUser, workflowInstanceId);
        return Result.success();
    }

    @Operation(summary="execute", description="EXECUTE_ACTION_TO_WORKFLOW_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="workflowInstanceId", description="WORKFLOW_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="executeType", description="EXECUTE_TYPE", required=true, schema=@Schema(implementation=ExecuteType.class))})
    @PostMapping(value={"/{workflowInstanceId}/execute/{executeType}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.EXECUTE_PROCESS_INSTANCE_ERROR)
    public Result execute(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="workflowInstanceId") Integer workflowInstanceId, @PathVariable(value="executeType") ExecuteType executeType) {
        Map<String, Object> result = this.execService.execute(loginUser, workflowInstanceId, executeType);
        return this.returnDataList(result);
    }
}

