/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowCreateRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowFilterRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="WORKFLOW_TAG_V2")
@RestController
@RequestMapping(value={"/v2/workflows"})
public class WorkflowV2Controller
extends BaseController {
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @Operation(summary="create", description="CREATE_WORKFLOWS_NOTES")
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_PROCESS_DEFINITION_ERROR)
    public Result<ProcessDefinition> createWorkflow(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody WorkflowCreateRequest workflowCreateRequest) {
        ProcessDefinition processDefinition = this.processDefinitionService.createSingleProcessDefinition(loginUser, workflowCreateRequest);
        return Result.success(processDefinition);
    }

    @Operation(summary="delete", description="DELETE_WORKFLOWS_NOTES")
    @Parameters(value={@Parameter(name="code", description="WORKFLOW_CODE", schema=@Schema(implementation=long.class, example="123456", required=true))})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR)
    public Result deleteWorkflow(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        this.processDefinitionService.deleteProcessDefinitionByCode(loginUser, code);
        return Result.success();
    }

    @Operation(summary="update", description="UPDATE_WORKFLOWS_NOTES")
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_PROCESS_DEFINITION_ERROR)
    public Result<ProcessDefinition> updateWorkflow(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code, @RequestBody WorkflowUpdateRequest workflowUpdateRequest) {
        ProcessDefinition processDefinition = this.processDefinitionService.updateSingleProcessDefinition(loginUser, code, workflowUpdateRequest);
        return Result.success(processDefinition);
    }

    @Operation(summary="get", description="GET_WORKFLOWS_NOTES")
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    public Result<ProcessDefinition> getWorkflow(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="code") Long code) {
        ProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(loginUser, code);
        return Result.success(processDefinition);
    }

    @Operation(summary="get", description="FILTER_WORKFLOWS_NOTES")
    @PostMapping(value={"/query"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_PROCESS_DEFINITION_LIST)
    public Result<PageInfo<ProcessDefinition>> filterWorkflows(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody WorkflowFilterRequest workflowFilterRequest) {
        PageInfo<ProcessDefinition> processDefinitions = this.processDefinitionService.filterProcessDefinition(loginUser, workflowFilterRequest);
        return Result.success(processDefinitions);
    }
}

