/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.schedule;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.PageQueryDto;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.Schedule;

@Schema(name="SCHEDULE-QUERY")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduleFilterRequest
extends PageQueryDto {
    @Schema(example="project-name")
    private String projectName;
    @Schema(example="process-definition-name")
    private String processDefinitionName;
    @Schema(allowableValues={"ONLINE / OFFLINE"}, example="OFFLINE", description="default OFFLINE if value not provide.")
    private String releaseState;

    public Schedule convert2Schedule() {
        Schedule schedule = new Schedule();
        if (this.projectName != null) {
            schedule.setProjectName(this.projectName);
        }
        if (this.processDefinitionName != null) {
            schedule.setProcessDefinitionName(this.processDefinitionName);
        }
        if (this.releaseState != null) {
            schedule.setReleaseState(ReleaseState.valueOf((String)this.releaseState));
        }
        return schedule;
    }

    @Generated
    public ScheduleFilterRequest() {
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleFilterRequest)) {
            return false;
        }
        ScheduleFilterRequest other = (ScheduleFilterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$processDefinitionName = this.getProcessDefinitionName();
        String other$processDefinitionName = other.getProcessDefinitionName();
        if (this$processDefinitionName == null ? other$processDefinitionName != null : !this$processDefinitionName.equals(other$processDefinitionName)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        return !(this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduleFilterRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $processDefinitionName = this.getProcessDefinitionName();
        result = result * 59 + ($processDefinitionName == null ? 43 : $processDefinitionName.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ScheduleFilterRequest(projectName=" + this.getProjectName() + ", processDefinitionName=" + this.getProcessDefinitionName() + ", releaseState=" + this.getReleaseState() + ")";
    }
}

