/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.workflow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ProcessExecutionTypeEnum;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;

public class WorkflowCreateRequest {
    @Schema(example="workflow name", required=true)
    private String name;
    @Schema(example="workflow's description")
    private String description;
    @Schema(example="12345", required=true)
    private long projectCode;
    @Schema(allowableValues={"ONLINE / OFFLINE"}, example="OFFLINE", description="default OFFLINE if not provide.")
    private String releaseState;
    @Schema(example="[{\"prop\":\"key\",\"value\":\"value\",\"direct\":\"IN\",\"type\":\"VARCHAR\"}]")
    private String globalParams;
    @Schema(example="2")
    private int warningGroupId;
    @Schema(example="60")
    private int timeout;
    @Schema(allowableValues={"PARALLEL / SERIAL_WAIT / SERIAL_DISCARD / SERIAL_PRIORITY"}, example="PARALLEL", description="default PARALLEL if not provide.")
    private String executionType;

    public ProcessDefinition convert2ProcessDefinition() {
        ProcessDefinition processDefinition = new ProcessDefinition();
        processDefinition.setName(this.name);
        processDefinition.setDescription(this.description);
        processDefinition.setProjectCode(this.projectCode);
        processDefinition.setGlobalParams(this.globalParams);
        processDefinition.setWarningGroupId(Integer.valueOf(this.warningGroupId));
        processDefinition.setTimeout(this.timeout);
        ReleaseState pdReleaseState = this.releaseState == null ? ReleaseState.OFFLINE : ReleaseState.valueOf((String)this.releaseState);
        processDefinition.setReleaseState(pdReleaseState);
        ProcessExecutionTypeEnum processExecutionTypeEnum = this.executionType == null ? ProcessExecutionTypeEnum.PARALLEL : ProcessExecutionTypeEnum.valueOf((String)this.executionType);
        processDefinition.setExecutionType(processExecutionTypeEnum);
        processDefinition.setVersion(1);
        Date date = new Date();
        processDefinition.setCreateTime(date);
        processDefinition.setUpdateTime(date);
        return processDefinition;
    }

    @Generated
    public WorkflowCreateRequest() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public String getGlobalParams() {
        return this.globalParams;
    }

    @Generated
    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getExecutionType() {
        return this.executionType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    @Generated
    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setExecutionType(String executionType) {
        this.executionType = executionType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowCreateRequest)) {
            return false;
        }
        WorkflowCreateRequest other = (WorkflowCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProjectCode() != other.getProjectCode()) {
            return false;
        }
        if (this.getWarningGroupId() != other.getWarningGroupId()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$executionType = this.getExecutionType();
        String other$executionType = other.getExecutionType();
        return !(this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $projectCode = this.getProjectCode();
        result = result * 59 + (int)($projectCode >>> 32 ^ $projectCode);
        result = result * 59 + this.getWarningGroupId();
        result = result * 59 + this.getTimeout();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkflowCreateRequest(name=" + this.getName() + ", description=" + this.getDescription() + ", projectCode=" + this.getProjectCode() + ", releaseState=" + this.getReleaseState() + ", globalParams=" + this.getGlobalParams() + ", warningGroupId=" + this.getWarningGroupId() + ", timeout=" + this.getTimeout() + ", executionType=" + this.getExecutionType() + ")";
    }
}

