/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.exceptions;

import java.text.MessageFormat;
import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.Status;

public class ServiceException
extends RuntimeException {
    private int code;

    public ServiceException() {
        this(Status.INTERNAL_SERVER_ERROR_ARGS);
    }

    public ServiceException(Status status) {
        this(status.getCode(), status.getMsg());
    }

    public ServiceException(Status status, Object ... formatter) {
        this(status.getCode(), MessageFormat.format(status.getMsg(), formatter));
    }

    public ServiceException(String message) {
        this(Status.INTERNAL_SERVER_ERROR_ARGS, message);
    }

    public ServiceException(int code, String message) {
        this(code, message, null);
    }

    public ServiceException(int code, String message, Exception cause) {
        super(message, cause);
        this.code = code;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public void setCode(int code) {
        this.code = code;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceException)) {
            return false;
        }
        ServiceException other = (ServiceException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getCode() == other.getCode();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ServiceException(code=" + this.getCode() + ")";
    }
}

