/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery;

import java.util.concurrent.CompletableFuture;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.executor.ExecuteContext;
import org.apache.dolphinscheduler.api.executor.ExecuteFunction;
import org.apache.dolphinscheduler.api.executor.ExecuteFunctionBuilder;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryExecuteFunction;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryRequest;
import org.apache.dolphinscheduler.api.executor.workflow.instance.failure.recovery.FailureRecoveryResult;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FailureRecoveryExecuteFunctionBuilder
implements ExecuteFunctionBuilder<FailureRecoveryRequest, FailureRecoveryResult> {
    public static final ExecuteType EXECUTE_TYPE = ExecuteType.START_FAILURE_TASK_PROCESS;
    @Autowired
    private CommandService commandService;

    @Override
    public CompletableFuture<ExecuteFunction<FailureRecoveryRequest, FailureRecoveryResult>> createWorkflowInstanceExecuteFunction(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new FailureRecoveryExecuteFunction(this.commandService));
    }

    @Override
    public CompletableFuture<FailureRecoveryRequest> createWorkflowInstanceExecuteRequest(ExecuteContext executeContext) {
        return CompletableFuture.completedFuture(new FailureRecoveryRequest(executeContext.getWorkflowInstance(), executeContext.getWorkflowDefinition(), executeContext.getExecuteUser()));
    }

    @Override
    public ExecuteType getExecuteType() {
        return EXECUTE_TYPE;
    }
}

